/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.base.Enums;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.DummyCryptoKeyReaderImpl;
import org.apache.pulsar.client.api.HashingScheme;
import org.apache.pulsar.client.api.MessageCrypto;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.impl.TypedMessageBuilderImpl;
import org.apache.pulsar.common.api.EncryptionContext;
import org.apache.pulsar.common.api.proto.CompressionType;
import org.apache.pulsar.common.api.proto.KeyValue;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.common.util.DateFormatter;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.websocket.AbstractWebSocketHandler;
import org.apache.pulsar.websocket.WebSocketError;
import org.apache.pulsar.websocket.WebSocketService;
import org.apache.pulsar.websocket.data.ProducerAck;
import org.apache.pulsar.websocket.data.ProducerMessage;
import org.apache.pulsar.websocket.service.WSSDummyMessageCryptoImpl;
import org.apache.pulsar.websocket.stats.StatsBuckets;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerHandler
extends AbstractWebSocketHandler {
    private WebSocketService service;
    private Producer<byte[]> producer;
    private final LongAdder numMsgsSent;
    private final LongAdder numMsgsFailed;
    private final LongAdder numBytesSent;
    private final StatsBuckets publishLatencyStatsUSec;
    private volatile long msgPublishedCounter = 0L;
    private boolean clientSideEncrypt;
    private static final AtomicLongFieldUpdater<ProducerHandler> MSG_PUBLISHED_COUNTER_UPDATER = AtomicLongFieldUpdater.newUpdater(ProducerHandler.class, "msgPublishedCounter");
    public static final List<Long> ENTRY_LATENCY_BUCKETS_USEC = Collections.unmodifiableList(Arrays.asList(500L, 1000L, 5000L, 10000L, 20000L, 50000L, 100000L, 200000L, 1000000L));
    private final ObjectReader producerMessageReader = ObjectMapperFactory.getMapper().reader().forType(ProducerMessage.class);
    private static final Logger log = LoggerFactory.getLogger(ProducerHandler.class);

    public ProducerHandler(WebSocketService service, HttpServletRequest request, ServletUpgradeResponse response) {
        super(service, request, response);
        this.numMsgsSent = new LongAdder();
        this.numBytesSent = new LongAdder();
        this.numMsgsFailed = new LongAdder();
        this.publishLatencyStatsUSec = new StatsBuckets(ENTRY_LATENCY_BUCKETS_USEC);
        this.service = service;
        if (!this.checkAuth(response)) {
            return;
        }
        try {
            this.producer = this.getProducerBuilder(service.getPulsarClient()).topic(this.topic.toString()).create();
            if (this.clientSideEncrypt) {
                log.info("[{}] [{}] The producer session is created with param encryptionKeyValues, which means that message encryption will be done on the client side, then the server will skip batch message processing, message compression processing, and message encryption processing", (Object)this.producer.getTopic(), (Object)this.producer.getProducerName());
            }
            if (!this.service.addProducer(this)) {
                log.warn("[{}:{}] Failed to add producer handler for topic {}", new Object[]{request.getRemoteAddr(), request.getRemotePort(), this.topic});
            }
        }
        catch (Exception e) {
            log.warn("[{}:{}] Failed in creating producer on topic {}: {}", new Object[]{request.getRemoteAddr(), request.getRemotePort(), this.topic, e.getMessage()});
            try {
                response.sendError(ProducerHandler.getErrorCode(e), ProducerHandler.getErrorMessage(e));
            }
            catch (IOException e1) {
                log.warn("[{}:{}] Failed to send error: {}", new Object[]{request.getRemoteAddr(), request.getRemotePort(), e1.getMessage(), e1});
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.producer != null) {
            if (!this.service.removeProducer(this)) {
                log.warn("[{}] Failed to remove producer handler", (Object)this.producer.getTopic());
            }
            ((CompletableFuture)this.producer.closeAsync().thenAccept(x -> {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Closed producer asynchronously", (Object)this.producer.getTopic());
                }
            })).exceptionally(exception -> {
                log.warn("[{}] Failed to close producer", (Object)this.producer.getTopic(), exception);
                return null;
            });
        }
    }

    public void onWebSocketText(String message) {
        ProducerMessage sendRequest;
        if (log.isDebugEnabled()) {
            log.debug("[{}] Received new message from producer {} ", (Object)this.producer.getTopic(), (Object)this.getRemote().getInetSocketAddress().toString());
        }
        byte[] rawPayload = null;
        String requestContext = null;
        try {
            sendRequest = (ProducerMessage)this.producerMessageReader.readValue(message);
            requestContext = sendRequest.context;
            rawPayload = Base64.getDecoder().decode(sendRequest.payload);
        }
        catch (IOException e) {
            this.sendAckResponse(new ProducerAck(WebSocketError.FailedToDeserializeFromJSON, e.getMessage(), null, null));
            return;
        }
        catch (IllegalArgumentException e) {
            String msg = String.format("Invalid Base64 message-payload error=%s", e.getMessage());
            this.sendAckResponse(new ProducerAck(WebSocketError.PayloadEncodingError, msg, null, requestContext));
            return;
        }
        catch (NullPointerException e) {
            this.sendAckResponse(new ProducerAck(WebSocketError.PayloadEncodingError, e.getMessage(), null, requestContext));
            return;
        }
        long msgSize = rawPayload.length;
        TypedMessageBuilderImpl builder = (TypedMessageBuilderImpl)this.producer.newMessage();
        try {
            builder.value((Object)rawPayload);
        }
        catch (SchemaSerializationException e) {
            this.sendAckResponse(new ProducerAck(WebSocketError.PayloadEncodingError, e.getMessage(), null, requestContext));
            return;
        }
        if (sendRequest.properties != null) {
            builder.properties(sendRequest.properties);
        }
        if (sendRequest.key != null) {
            builder.key(sendRequest.key);
        }
        if (sendRequest.replicationClusters != null) {
            builder.replicationClusters(sendRequest.replicationClusters);
        }
        if (sendRequest.eventTime != null) {
            try {
                builder.eventTime(DateFormatter.parse((String)sendRequest.eventTime));
            }
            catch (DateTimeParseException e) {
                this.sendAckResponse(new ProducerAck(WebSocketError.PayloadEncodingError, e.getMessage(), null, requestContext));
                return;
            }
        }
        if (sendRequest.deliverAt > 0L) {
            builder.deliverAt(sendRequest.deliverAt);
        }
        if (sendRequest.deliverAfterMs > 0L) {
            builder.deliverAfter(sendRequest.deliverAfterMs, TimeUnit.MILLISECONDS);
        }
        if (this.clientSideEncrypt) {
            try {
                if (!StringUtils.isBlank((CharSequence)sendRequest.encryptionParam)) {
                    builder.getMetadataBuilder().setEncryptionParam(Base64.getDecoder().decode(sendRequest.encryptionParam));
                }
            }
            catch (Exception e) {
                String msg = String.format("Invalid Base64 encryptionParam error=%s", e.getMessage());
                this.sendAckResponse(new ProducerAck(WebSocketError.PayloadEncodingError, msg, null, requestContext));
                return;
            }
            if (sendRequest.compressionType != null && sendRequest.uncompressedMessageSize != null) {
                builder.getMetadataBuilder().setCompression(sendRequest.compressionType);
                builder.getMetadataBuilder().setUncompressedSize(sendRequest.uncompressedMessageSize.intValue());
            } else if (!CompressionType.NONE.equals((Object)sendRequest.compressionType) && sendRequest.compressionType != null || sendRequest.uncompressedMessageSize != null) {
                this.sendAckResponse(new ProducerAck(WebSocketError.PayloadEncodingError, "the params compressionType and uncompressedMessageSize should both empty or both non-empty", null, requestContext));
                return;
            }
        }
        long now = System.nanoTime();
        ((CompletableFuture)builder.sendAsync().thenAccept(msgId -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Success fully write the message to broker with returned message ID {} from producer {}", new Object[]{this.producer.getTopic(), msgId, this.getRemote().getInetSocketAddress().toString()});
            }
            this.updateSentMsgStats(msgSize, TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - now));
            if (this.isConnected()) {
                String messageId = Base64.getEncoder().encodeToString(msgId.toByteArray());
                this.sendAckResponse(new ProducerAck(messageId, sendRequest.context));
            }
        })).exceptionally(exception -> {
            log.warn("[{}] Error occurred while producer handler was sending msg from {}", new Object[]{this.producer.getTopic(), this.getRemote().getInetSocketAddress().toString(), exception});
            this.numMsgsFailed.increment();
            this.sendAckResponse(new ProducerAck(WebSocketError.UnknownError, exception.getMessage(), null, sendRequest.context));
            return null;
        });
    }

    public Producer<byte[]> getProducer() {
        return this.producer;
    }

    public long getAndResetNumMsgsSent() {
        return this.numMsgsSent.sumThenReset();
    }

    public long getAndResetNumBytesSent() {
        return this.numBytesSent.sumThenReset();
    }

    public long getAndResetNumMsgsFailed() {
        return this.numMsgsFailed.sumThenReset();
    }

    public long[] getAndResetPublishLatencyStatsUSec() {
        this.publishLatencyStatsUSec.refresh();
        return this.publishLatencyStatsUSec.getBuckets();
    }

    public StatsBuckets getPublishLatencyStatsUSec() {
        return this.publishLatencyStatsUSec;
    }

    public long getMsgPublishedCounter() {
        return this.msgPublishedCounter;
    }

    @Override
    protected Boolean isAuthorized(String authRole, AuthenticationDataSource authenticationData) throws Exception {
        try {
            return (Boolean)this.service.getAuthorizationService().allowTopicOperationAsync(this.topic, TopicOperation.PRODUCE, authRole, authenticationData).get(this.service.getConfig().getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.warn("Time-out {} sec while checking authorization on {} ", (Object)this.service.getConfig().getMetadataStoreOperationTimeoutSeconds(), (Object)this.topic);
            throw e;
        }
        catch (Exception e) {
            log.warn("Producer-client  with Role - {} failed to get permissions for topic - {}. {}", new Object[]{authRole, this.topic, e.getMessage()});
            throw e;
        }
    }

    private void sendAckResponse(ProducerAck response) {
        try {
            String msg = this.objectWriter().writeValueAsString((Object)response);
            this.getSession().getRemote().sendString(msg, new WriteCallback(){

                public void writeFailed(Throwable th) {
                    log.warn("[{}] Failed to send ack: {}", (Object)ProducerHandler.this.producer.getTopic(), (Object)th.getMessage());
                }

                public void writeSuccess() {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Ack was sent successfully to {}", (Object)ProducerHandler.this.producer.getTopic(), (Object)ProducerHandler.this.getRemote().getInetSocketAddress().toString());
                    }
                }
            });
        }
        catch (JsonProcessingException e) {
            log.warn("[{}] Failed to generate ack json-response: {}", (Object)this.producer.getTopic(), (Object)e.getMessage());
        }
        catch (Exception e) {
            log.warn("[{}] Failed to send ack: {}", (Object)this.producer.getTopic(), (Object)e.getMessage());
        }
    }

    private void updateSentMsgStats(long msgSize, long latencyUsec) {
        this.publishLatencyStatsUSec.addValue(latencyUsec);
        this.numBytesSent.add(msgSize);
        this.numMsgsSent.increment();
        MSG_PUBLISHED_COUNTER_UPDATER.getAndIncrement(this);
    }

    protected ProducerBuilder<byte[]> getProducerBuilder(PulsarClient client) {
        Map<String, EncryptionContext.EncryptionKey> encryptionKeyMap;
        ProducerBuilder builder = client.newProducer().enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition);
        builder.blockIfQueueFull(false);
        if (this.queryParams.containsKey("producerName")) {
            builder.producerName((String)this.queryParams.get("producerName"));
        }
        if (this.queryParams.containsKey("initialSequenceId")) {
            builder.initialSequenceId(Long.parseLong((String)this.queryParams.get("initialSequenceId")));
        }
        if (this.queryParams.containsKey("hashingScheme")) {
            builder.hashingScheme(HashingScheme.valueOf((String)((String)this.queryParams.get("hashingScheme"))));
        }
        if (this.queryParams.containsKey("sendTimeoutMillis")) {
            builder.sendTimeout(Integer.parseInt((String)this.queryParams.get("sendTimeoutMillis")), TimeUnit.MILLISECONDS);
        }
        if (this.queryParams.containsKey("messageRoutingMode")) {
            Preconditions.checkArgument((boolean)Enums.getIfPresent(MessageRoutingMode.class, (String)((String)this.queryParams.get("messageRoutingMode"))).isPresent(), (String)"Invalid messageRoutingMode %s", this.queryParams.get("messageRoutingMode"));
            MessageRoutingMode routingMode = MessageRoutingMode.valueOf((String)((String)this.queryParams.get("messageRoutingMode")));
            if (!MessageRoutingMode.CustomPartition.equals((Object)routingMode)) {
                builder.messageRoutingMode(routingMode);
            }
        }
        if ((encryptionKeyMap = this.tryToExtractJsonEncryptionKeys()) != null) {
            this.popularProducerBuilderForClientSideEncrypt((ProducerBuilder<byte[]>)builder, encryptionKeyMap);
        } else {
            this.popularProducerBuilderForServerSideEncrypt((ProducerBuilder<byte[]>)builder);
        }
        return builder;
    }

    private Map<String, EncryptionContext.EncryptionKey> tryToExtractJsonEncryptionKeys() {
        if (!this.queryParams.containsKey("encryptionKeys")) {
            return null;
        }
        byte[] param = null;
        try {
            param = Base64.getDecoder().decode(StringUtils.trim((String)((String)this.queryParams.get("encryptionKeys"))));
        }
        catch (Exception base64DecodeEx) {
            return null;
        }
        try {
            Map keys = (Map)ObjectMapperFactory.getMapper().getObjectMapper().readValue(param, (TypeReference)new TypeReference<Map<String, EncryptionContext.EncryptionKey>>(){});
            if (keys.isEmpty()) {
                return null;
            }
            if (((EncryptionContext.EncryptionKey)keys.values().iterator().next()).getKeyValue() == null) {
                return null;
            }
            return keys;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private void popularProducerBuilderForClientSideEncrypt(ProducerBuilder<byte[]> builder, Map<String, EncryptionContext.EncryptionKey> encryptionKeyMap) {
        this.clientSideEncrypt = true;
        int keysLen = encryptionKeyMap.size();
        String[] keyNameArray = new String[keysLen];
        byte[][] keyValueArray = new byte[keysLen][];
        List[] keyMetadataArray = new List[keysLen];
        int index = 0;
        for (Map.Entry<String, EncryptionContext.EncryptionKey> entry : encryptionKeyMap.entrySet()) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)entry.getKey()), (Object)"Empty param encryptionKeys.key");
            Preconditions.checkArgument((entry.getValue() != null ? 1 : 0) != 0, (Object)"Empty param encryptionKeys.value");
            Preconditions.checkArgument((entry.getValue().getKeyValue() != null ? 1 : 0) != 0, (Object)"Empty param encryptionKeys.value.keyValue");
            keyNameArray[index] = StringUtils.trim((String)entry.getKey());
            keyValueArray[index] = entry.getValue().getKeyValue();
            keyMetadataArray[index] = entry.getValue().getMetadata() == null ? Collections.emptyList() : entry.getValue().getMetadata().entrySet().stream().map(e -> new KeyValue().setKey((String)e.getKey()).setValue((String)e.getValue())).collect(Collectors.toList());
            builder.addEncryptionKey(keyNameArray[index]);
        }
        builder.enableBatching(false);
        builder.compressionType(org.apache.pulsar.client.api.CompressionType.NONE);
        builder.cryptoKeyReader((CryptoKeyReader)DummyCryptoKeyReaderImpl.INSTANCE);
        builder.enableChunking(false);
        builder.messageCrypto((MessageCrypto)new WSSDummyMessageCryptoImpl(msgMetadata -> {
            for (int i = 0; i < keyNameArray.length; ++i) {
                msgMetadata.addEncryptionKey().setKey(keyNameArray[i]).setValue(keyValueArray[i]).addAllMetadatas((Iterable)keyMetadataArray[i]);
            }
        }));
        this.printLogIfSettingDiscardedBatchedParams();
        this.printLogIfSettingDiscardedCompressionParams();
    }

    private void popularProducerBuilderForServerSideEncrypt(ProducerBuilder<byte[]> builder) {
        this.clientSideEncrypt = false;
        if (this.queryParams.containsKey("batchingEnabled")) {
            boolean batchingEnabled = Boolean.parseBoolean((String)this.queryParams.get("batchingEnabled"));
            if (batchingEnabled) {
                builder.enableBatching(true);
                if (this.queryParams.containsKey("batchingMaxMessages")) {
                    builder.batchingMaxMessages(Integer.parseInt((String)this.queryParams.get("batchingMaxMessages")));
                }
                if (this.queryParams.containsKey("maxPendingMessages")) {
                    builder.maxPendingMessages(Integer.parseInt((String)this.queryParams.get("maxPendingMessages")));
                }
                if (this.queryParams.containsKey("batchingMaxPublishDelay")) {
                    builder.batchingMaxPublishDelay((long)Integer.parseInt((String)this.queryParams.get("batchingMaxPublishDelay")), TimeUnit.MILLISECONDS);
                }
            } else {
                builder.enableBatching(false);
                this.printLogIfSettingDiscardedBatchedParams();
            }
        }
        if (this.queryParams.containsKey("compressionType")) {
            Preconditions.checkArgument((boolean)Enums.getIfPresent(org.apache.pulsar.client.api.CompressionType.class, (String)((String)this.queryParams.get("compressionType"))).isPresent(), (String)"Invalid compressionType %s", this.queryParams.get("compressionType"));
            builder.compressionType(org.apache.pulsar.client.api.CompressionType.valueOf((String)((String)this.queryParams.get("compressionType"))));
        }
        if (this.queryParams.containsKey("encryptionKeys")) {
            String[] keys;
            builder.cryptoKeyReader(this.service.getCryptoKeyReader().orElseThrow(() -> new IllegalStateException("Can't add encryption key without configuring cryptoKeyReaderFactoryClassName")));
            for (String key : keys = ((String)this.queryParams.get("encryptionKeys")).split(",")) {
                builder.addEncryptionKey(key);
            }
        }
    }

    private void printLogIfSettingDiscardedBatchedParams() {
        if (this.clientSideEncrypt && this.queryParams.containsKey("batchingEnabled")) {
            log.info("Since clientSideEncrypt is true, the param batchingEnabled of producer will be ignored");
        }
        if (this.queryParams.containsKey("batchingMaxMessages")) {
            log.info("Since batchingEnabled is false, the param batchingMaxMessages of producer will be ignored");
        }
        if (this.queryParams.containsKey("maxPendingMessages")) {
            log.info("Since batchingEnabled is false, the param maxPendingMessages of producer will be ignored");
        }
        if (this.queryParams.containsKey("batchingMaxPublishDelay")) {
            log.info("Since batchingEnabled is false, the param batchingMaxPublishDelay of producer will be ignored");
        }
    }

    private void printLogIfSettingDiscardedCompressionParams() {
        if (this.clientSideEncrypt && this.queryParams.containsKey("compressionType")) {
            log.info("Since clientSideEncrypt is true, the param compressionType of producer will be ignored");
        }
    }
}

