/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ChannelFutures {
    private ChannelFutures() {
        throw new AssertionError((Object)"Class with static utility methods only cannot be instantiated");
    }

    public static CompletableFuture<Channel> toCompletableFuture(ChannelFuture channelFuture) {
        Objects.requireNonNull(channelFuture, "channelFuture cannot be null");
        CompletableFuture<Channel> adapter = new CompletableFuture<Channel>();
        if (channelFuture.isDone()) {
            if (channelFuture.isSuccess()) {
                adapter.complete(channelFuture.channel());
            } else {
                adapter.completeExceptionally(channelFuture.cause());
            }
        } else {
            channelFuture.addListener(cf -> {
                if (cf.isSuccess()) {
                    adapter.complete(cf.channel());
                } else {
                    adapter.completeExceptionally(cf.cause());
                }
            });
        }
        return adapter;
    }
}

