/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.nar;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.pulsar.common.nar.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarUnpacker {
    private static final Logger log = LoggerFactory.getLogger(NarUnpacker.class);
    private static final ConcurrentHashMap<String, Object> CURRENT_JVM_FILE_LOCKS = new ConcurrentHashMap();

    public static File unpackNar(File nar, File baseWorkingDirectory) throws IOException {
        return NarUnpacker.doUnpackNar(nar, baseWorkingDirectory, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    static File doUnpackNar(File nar, File baseWorkingDirectory, Runnable extractCallback) throws IOException {
        Object localLock;
        File parentDirectory = new File(baseWorkingDirectory, nar.getName() + "-unpacked");
        if (!parentDirectory.exists()) {
            if (parentDirectory.mkdirs()) {
                log.info("Created directory {}", (Object)parentDirectory);
            } else if (!parentDirectory.exists()) {
                throw new IOException("Cannot create " + parentDirectory);
            }
        }
        String md5Sum = Base64.getUrlEncoder().withoutPadding().encodeToString(NarUnpacker.calculateMd5sum(nar));
        File lockFile = new File(parentDirectory, "." + md5Sum + ".lock");
        Object object = localLock = CURRENT_JVM_FILE_LOCKS.computeIfAbsent(lockFile.getAbsolutePath(), key -> new Object());
        synchronized (object) {
            try (FileChannel channel = new RandomAccessFile(lockFile, "rw").getChannel();){
                File file;
                block23: {
                    FileLock lock = channel.lock();
                    try {
                        File narWorkingDirectory = new File(parentDirectory, md5Sum);
                        if (narWorkingDirectory.mkdir()) {
                            try {
                                log.info("Extracting {} to {}", (Object)nar, (Object)narWorkingDirectory);
                                if (extractCallback != null) {
                                    extractCallback.run();
                                }
                                NarUnpacker.unpack(nar, narWorkingDirectory);
                            }
                            catch (IOException e) {
                                log.error("There was a problem extracting the nar file. Deleting {} to clean up state.", (Object)narWorkingDirectory, (Object)e);
                                FileUtils.deleteFile(narWorkingDirectory, true);
                                throw e;
                            }
                        }
                        file = narWorkingDirectory;
                        if (lock == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (lock != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    lock.close();
                }
                return file;
            }
        }
    }

    private static void unpack(File nar, File workingDirectory) throws IOException {
        try (JarFile jarFile = new JarFile(nar);){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                File f = new File(workingDirectory, name);
                if (jarEntry.isDirectory()) {
                    FileUtils.ensureDirectoryExistAndCanReadAndWrite(f);
                    continue;
                }
                FileUtils.ensureDirectoryExistAndCanReadAndWrite(f.getParentFile());
                NarUnpacker.makeFile(jarFile.getInputStream(jarEntry), f);
            }
        }
    }

    private static void makeFile(InputStream inputStream, File file) throws IOException {
        try (InputStream in = inputStream;
             FileOutputStream fos = new FileOutputStream(file);){
            int numRead;
            byte[] bytes = new byte[65536];
            while ((numRead = in.read(bytes)) != -1) {
                fos.write(bytes, 0, numRead);
            }
        }
    }

    private static byte[] calculateMd5sum(File file) throws IOException {
        byte[] byArray;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            MessageDigest md5 = MessageDigest.getInstance("md5");
            byte[] buffer = new byte[1024];
            int read = inputStream.read(buffer);
            while (read > -1) {
                md5.update(buffer, 0, read);
                read = inputStream.read(buffer);
            }
            byArray = md5.digest();
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new IllegalArgumentException(nsae);
            }
        }
        inputStream.close();
        return byArray;
    }
}

