/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.cli;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.IUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SizeUnit;
import org.apache.pulsar.client.cli.CmdConsume;
import org.apache.pulsar.client.cli.CmdGenerateDocumentation;
import org.apache.pulsar.client.cli.CmdProduce;

public class PulsarClientTool {
    protected RootParams rootParams = new RootParams();
    boolean tlsAllowInsecureConnection;
    boolean tlsEnableHostnameVerification;
    String tlsKeyFilePath;
    String tlsCertificateFilePath;
    boolean useKeyStoreTls;
    String tlsTrustStoreType;
    String tlsTrustStorePath;
    String tlsTrustStorePassword;
    String tlsKeyStoreType;
    String tlsKeyStorePath;
    String tlsKeyStorePassword;
    protected JCommander jcommander;
    IUsageFormatter usageFormatter;
    CmdProduce produceCommand;
    CmdConsume consumeCommand;
    CmdGenerateDocumentation generateDocumentation;

    public PulsarClientTool(Properties properties) {
        this.initRootParamsFromProperties(properties);
        this.tlsAllowInsecureConnection = Boolean.parseBoolean(properties.getProperty("tlsAllowInsecureConnection", "false"));
        this.tlsEnableHostnameVerification = Boolean.parseBoolean(properties.getProperty("tlsEnableHostnameVerification", "false"));
        this.useKeyStoreTls = Boolean.parseBoolean(properties.getProperty("useKeyStoreTls", "false"));
        this.tlsTrustStoreType = properties.getProperty("tlsTrustStoreType", "JKS");
        this.tlsTrustStorePath = properties.getProperty("tlsTrustStorePath");
        this.tlsTrustStorePassword = properties.getProperty("tlsTrustStorePassword");
        this.tlsKeyStoreType = properties.getProperty("tlsKeyStoreType", "JKS");
        this.tlsKeyStorePath = properties.getProperty("tlsKeyStorePath");
        this.tlsKeyStorePassword = properties.getProperty("tlsKeyStorePassword");
        this.tlsKeyFilePath = properties.getProperty("tlsKeyFilePath");
        this.tlsCertificateFilePath = properties.getProperty("tlsCertificateFilePath");
        this.initJCommander();
    }

    protected void initJCommander() {
        this.produceCommand = new CmdProduce();
        this.consumeCommand = new CmdConsume();
        this.generateDocumentation = new CmdGenerateDocumentation();
        this.jcommander = new JCommander();
        this.usageFormatter = new DefaultUsageFormatter(this.jcommander);
        this.jcommander.setProgramName("pulsar-client");
        this.jcommander.addObject((Object)this.rootParams);
        this.jcommander.addCommand("produce", (Object)this.produceCommand);
        this.jcommander.addCommand("consume", (Object)this.consumeCommand);
        this.jcommander.addCommand("generate_documentation", (Object)this.generateDocumentation);
    }

    protected void initRootParamsFromProperties(Properties properties) {
        String string = this.rootParams.serviceURL = StringUtils.isNotBlank((CharSequence)properties.getProperty("brokerServiceUrl")) ? properties.getProperty("brokerServiceUrl") : properties.getProperty("webServiceUrl");
        if (StringUtils.isBlank((CharSequence)this.rootParams.serviceURL)) {
            this.rootParams.serviceURL = properties.getProperty("serviceUrl");
        }
        this.rootParams.authPluginClassName = properties.getProperty("authPlugin");
        this.rootParams.authParams = properties.getProperty("authParams");
        this.rootParams.tlsTrustCertsFilePath = properties.getProperty("tlsTrustCertsFilePath");
    }

    private void updateConfig() throws PulsarClientException.UnsupportedAuthenticationException {
        ClientBuilder clientBuilder = PulsarClient.builder().memoryLimit(0L, SizeUnit.BYTES);
        Authentication authentication = null;
        if (StringUtils.isNotBlank((CharSequence)this.rootParams.authPluginClassName)) {
            authentication = AuthenticationFactory.create((String)this.rootParams.authPluginClassName, (String)this.rootParams.authParams);
            clientBuilder.authentication(authentication);
        }
        if (StringUtils.isNotBlank((CharSequence)this.rootParams.listenerName)) {
            clientBuilder.listenerName(this.rootParams.listenerName);
        }
        clientBuilder.allowTlsInsecureConnection(this.tlsAllowInsecureConnection);
        clientBuilder.enableTlsHostnameVerification(this.tlsEnableHostnameVerification);
        clientBuilder.serviceUrl(this.rootParams.serviceURL);
        clientBuilder.tlsTrustCertsFilePath(this.rootParams.tlsTrustCertsFilePath).tlsKeyFilePath(this.tlsKeyFilePath).tlsCertificateFilePath(this.tlsCertificateFilePath);
        clientBuilder.useKeyStoreTls(this.useKeyStoreTls).tlsTrustStoreType(this.tlsTrustStoreType).tlsTrustStorePath(this.tlsTrustStorePath).tlsTrustStorePassword(this.tlsTrustStorePassword).tlsKeyStoreType(this.tlsKeyStoreType).tlsKeyStorePath(this.tlsKeyStorePath).tlsKeyStorePassword(this.tlsKeyStorePassword);
        if (StringUtils.isNotBlank((CharSequence)this.rootParams.proxyServiceURL)) {
            if (this.rootParams.proxyProtocol == null) {
                System.out.println("proxy-protocol must be provided with proxy-url");
                System.exit(-1);
            }
            clientBuilder.proxyServiceUrl(this.rootParams.proxyServiceURL, this.rootParams.proxyProtocol);
        }
        this.produceCommand.updateConfig(clientBuilder, authentication, this.rootParams.serviceURL);
        this.consumeCommand.updateConfig(clientBuilder, authentication, this.rootParams.serviceURL);
    }

    public int run(String[] args) {
        try {
            this.jcommander.parse(args);
            if (StringUtils.isBlank((CharSequence)this.rootParams.serviceURL)) {
                this.jcommander.usage();
                return -1;
            }
            if (this.rootParams.version) {
                System.out.println("Current version of pulsar client is: " + PulsarVersion.getVersion());
                return 0;
            }
            if (this.rootParams.help) {
                this.jcommander.usage();
                return 0;
            }
            try {
                this.updateConfig();
            }
            catch (PulsarClientException.UnsupportedAuthenticationException exp) {
                System.out.println("Failed to load an authentication plugin");
                exp.printStackTrace();
                return -1;
            }
            String chosenCommand = this.jcommander.getParsedCommand();
            if ("produce".equals(chosenCommand)) {
                return this.produceCommand.run();
            }
            if ("consume".equals(chosenCommand)) {
                return this.consumeCommand.run();
            }
            if ("generate_documentation".equals(chosenCommand)) {
                return this.generateDocumentation.run();
            }
            this.jcommander.usage();
            return -1;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            String chosenCommand = this.jcommander.getParsedCommand();
            if (e instanceof ParameterException) {
                try {
                    this.usageFormatter.usage(chosenCommand);
                }
                catch (ParameterException noCmd) {
                    e.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
            return -1;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: pulsar-client CONF_FILE_PATH [options] [command] [command options]");
            System.exit(-1);
        }
        String configFile = args[0];
        Properties properties = new Properties();
        if (configFile != null) {
            try (FileInputStream fis = new FileInputStream(configFile);){
                properties.load(fis);
            }
        }
        PulsarClientTool clientTool = new PulsarClientTool(properties);
        int exitCode = clientTool.run(Arrays.copyOfRange(args, 1, args.length));
        System.exit(exitCode);
    }

    @Parameters(commandDescription="Produce or consume messages on a specified topic")
    public static class RootParams {
        @Parameter(names={"--url"}, description="Broker URL to which to connect.")
        String serviceURL = null;
        @Parameter(names={"--proxy-url"}, description="Proxy-server URL to which to connect.")
        String proxyServiceURL = null;
        @Parameter(names={"--proxy-protocol"}, description="Proxy protocol to select type of routing at proxy.")
        ProxyProtocol proxyProtocol = null;
        @Parameter(names={"--auth-plugin"}, description="Authentication plugin class name.")
        String authPluginClassName = null;
        @Parameter(names={"--listener-name"}, description="Listener name for the broker.")
        String listenerName = null;
        @Parameter(names={"--auth-params"}, description="Authentication parameters, whose format is determined by the implementation of method `configure` in authentication plugin class, for example \"key1:val1,key2:val2\" or \"{\"key1\":\"val1\",\"key2\":\"val2\"}.")
        String authParams = null;
        @Parameter(names={"-v", "--version"}, description="Get version of pulsar client")
        boolean version;
        @Parameter(names={"-h", "--help"}, help=true, description="Show this help.")
        boolean help;
        @Parameter(names={"--tlsTrustCertsFilePath"}, description="File path to client trust certificates")
        String tlsTrustCertsFilePath;

        public String getServiceURL() {
            return this.serviceURL;
        }

        public String getProxyServiceURL() {
            return this.proxyServiceURL;
        }

        public ProxyProtocol getProxyProtocol() {
            return this.proxyProtocol;
        }

        public String getAuthPluginClassName() {
            return this.authPluginClassName;
        }

        public String getListenerName() {
            return this.listenerName;
        }

        public String getAuthParams() {
            return this.authParams;
        }

        public boolean isVersion() {
            return this.version;
        }

        public boolean isHelp() {
            return this.help;
        }

        public String getTlsTrustCertsFilePath() {
            return this.tlsTrustCertsFilePath;
        }
    }
}

