/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.pluto.container.util.DummyPrintWriter;
import org.apache.pluto.container.util.DummyServletOutputStream;

public class HttpServletPortletResponseWrapper
extends HttpServletResponseWrapper {
    private final PortletResponse portletResponse;
    private boolean included;
    private OutputStream outputStream;
    private ServletOutputStream servletOutputStream;

    public HttpServletPortletResponseWrapper(HttpServletResponse response, PortletRequest portletRequest, PortletResponse portletResponse, boolean included) {
        super(response);
        this.portletResponse = portletResponse;
        this.included = included;
    }

    public void addCookie(Cookie cookie) {
        if (!this.included) {
            this.portletResponse.addProperty(cookie);
        }
    }

    public void addDateHeader(String name, long date) {
        if (!this.included && this.portletResponse instanceof MimeResponse) {
            ((MimeResponse)this.portletResponse).addProperty(name, Long.toString(date));
        }
    }

    public void addHeader(String name, String value) {
        if (!this.included && this.portletResponse instanceof MimeResponse) {
            ((MimeResponse)this.portletResponse).addProperty(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (!this.included && this.portletResponse instanceof MimeResponse) {
            ((MimeResponse)this.portletResponse).addProperty(name, Integer.toString(value));
        }
    }

    public boolean containsHeader(String name) {
        return false;
    }

    public String encodeRedirectUrl(String url) {
        return null;
    }

    public String encodeRedirectURL(String url) {
        return null;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeURL(String url) {
        return this.portletResponse.encodeURL(url);
    }

    public void sendError(int sc, String msg) throws IOException {
    }

    public void sendError(int sc) throws IOException {
    }

    public void sendRedirect(String location) throws IOException {
        if (!this.included && this.portletResponse instanceof ActionResponse) {
            ((ActionResponse)this.portletResponse).sendRedirect(location);
        }
    }

    public void setDateHeader(String name, long date) {
        if (!this.included && this.portletResponse instanceof MimeResponse) {
            ((MimeResponse)this.portletResponse).setProperty(name, Long.toString(date));
        }
    }

    public void setHeader(String name, String value) {
        if (!this.included && this.portletResponse instanceof MimeResponse) {
            ((MimeResponse)this.portletResponse).setProperty(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (!this.included && this.portletResponse instanceof MimeResponse) {
            ((MimeResponse)this.portletResponse).setProperty(name, Integer.toString(value));
        }
    }

    public void setStatus(int sc, String sm) {
        this.setStatus(sc);
    }

    public void setStatus(int sc) {
        if (!this.included && this.portletResponse instanceof ResourceResponse) {
            ((ResourceResponse)this.portletResponse).setProperty("portlet.http-status-code", Integer.toString(sc));
        }
    }

    public void flushBuffer() throws IOException {
        if (this.portletResponse instanceof MimeResponse) {
            ((MimeResponse)this.portletResponse).flushBuffer();
        }
    }

    public int getBufferSize() {
        if (this.portletResponse instanceof MimeResponse) {
            return ((MimeResponse)this.portletResponse).getBufferSize();
        }
        return 0;
    }

    public String getCharacterEncoding() {
        if (this.portletResponse instanceof MimeResponse) {
            return ((MimeResponse)this.portletResponse).getCharacterEncoding();
        }
        return null;
    }

    public String getContentType() {
        if (this.portletResponse instanceof MimeResponse) {
            return ((MimeResponse)this.portletResponse).getContentType();
        }
        return null;
    }

    public Locale getLocale() {
        if (this.portletResponse instanceof MimeResponse) {
            return ((MimeResponse)this.portletResponse).getLocale();
        }
        return null;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.servletOutputStream == null) {
            this.outputStream = this.portletResponse instanceof MimeResponse ? ((MimeResponse)this.portletResponse).getPortletOutputStream() : DummyServletOutputStream.getInstance();
            this.servletOutputStream = this.outputStream instanceof ServletOutputStream ? (ServletOutputStream)this.outputStream : new ServletOutputStream(){

                public void write(int b) throws IOException {
                    HttpServletPortletResponseWrapper.this.outputStream.write(b);
                }

                public boolean isReady() {
                    return true;
                }

                public void setWriteListener(WriteListener arg0) {
                }
            };
        }
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        PrintWriter writer = null;
        writer = this.portletResponse instanceof MimeResponse ? ((MimeResponse)this.portletResponse).getWriter() : DummyPrintWriter.getInstance();
        return writer;
    }

    public boolean isCommitted() {
        if (this.portletResponse instanceof MimeResponse) {
            return ((MimeResponse)this.portletResponse).isCommitted();
        }
        return this.included;
    }

    public void reset() {
        if (this.portletResponse instanceof MimeResponse) {
            ((MimeResponse)this.portletResponse).reset();
        }
    }

    public void resetBuffer() {
        if (this.portletResponse instanceof MimeResponse) {
            ((MimeResponse)this.portletResponse).resetBuffer();
        }
    }

    public void setBufferSize(int size) {
        if (this.portletResponse instanceof MimeResponse) {
            ((MimeResponse)this.portletResponse).setBufferSize(size);
        }
    }

    public void setCharacterEncoding(String charset) {
        if (!this.included && this.portletResponse instanceof ResourceResponse) {
            ((ResourceResponse)this.portletResponse).setCharacterEncoding(charset);
        }
    }

    public void setContentLength(int len) {
        if (!this.included && this.portletResponse instanceof ResourceResponse) {
            ((ResourceResponse)this.portletResponse).setContentLength(len);
        }
    }

    public void setContentType(String type) {
        if (!this.included && this.portletResponse instanceof MimeResponse) {
            ((MimeResponse)this.portletResponse).setContentType(type);
        }
    }

    public void setLocale(Locale loc) {
        if (!this.included && this.portletResponse instanceof ResourceResponse) {
            ((ResourceResponse)this.portletResponse).setLocale(loc);
        }
    }

    public void setContentLengthLong(long length) {
        if (this.portletResponse instanceof ResourceResponse) {
            ((ResourceResponse)this.portletResponse).setContentLengthLong(length);
        }
    }

    public int getStatus() {
        if (this.portletResponse instanceof ResourceResponse) {
            return ((ResourceResponse)this.portletResponse).getStatus();
        }
        return 200;
    }

    public String getHeader(String name) {
        return this.portletResponse.getProperty(name);
    }

    public Collection<String> getHeaderNames() {
        return this.portletResponse.getPropertyNames();
    }

    public Collection<String> getHeaders(String name) {
        return this.portletResponse.getPropertyValues(name);
    }
}

