/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.bean.processor.AnnotatedConfigBean;
import org.apache.pluto.container.bean.processor.AnnotatedMethodStore;
import org.apache.pluto.container.bean.processor.ConfigSummary;
import org.apache.pluto.container.bean.processor.PortletStateScopedConfig;

public class ConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = -3842324547802444406L;
    private StringBuilder errorString = new StringBuilder();
    public static final String ATTRIB_ERROR = "_Error";
    @Inject
    private AnnotatedConfigBean acb;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String portletName = "Fred";
        ConfigSummary summary = this.acb.getSummary();
        AnnotatedMethodStore ams = this.acb.getMethodStore();
        PortletStateScopedConfig config = this.acb.getStateScopedConfig();
        List<String> errors = summary.getErrorStrings(portletName);
        if (!ams.getPortletNames().contains(portletName) && errors.size() == 0) {
            this.errorString.append("<h3>Portlet Name: ").append(portletName).append("</h3>");
            this.errorString.append("<p>No portlet annotations could be found for this portlet.</p>");
            this.errorString.append("<h4>Deployment errors:</h4>");
            List<String> portletNames = summary.getPortletsWithErrors();
            portletNames.remove("*");
            Iterator iterator = portletNames.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                this.errorString.append("<p style='color: #00F; font: bold;'>Portlet: " + name + "</p>");
                List<String> errs = summary.getErrorStrings(name);
                for (String err : errs) {
                    this.errorString.append("<div style='padding-left: 15px;'>");
                    String[] lines = err.split("\\n");
                    this.errorString.append(lines[0]);
                    if (lines.length > 1) {
                        for (String line : Arrays.copyOfRange(lines, 1, lines.length)) {
                            this.errorString.append("<div style='padding-left: 15px;'>");
                            this.errorString.append(line);
                            this.errorString.append("</div>");
                        }
                    }
                    this.errorString.append("</div>");
                }
            }
            this.errorString.append("<h4>Available annotated portlet artifacts:</h4>");
            this.formatToErrorString(ams.getMethodsAsString().split("\n"));
            this.errorString.append("<h4>RenderStateScoped Bean Configuration:</h4>");
            this.formatToErrorString(config.getConfigAsString().split("\n"));
        } else if (errors.size() > 0) {
            this.errorString.append("<h3>Portlet Name: ").append(portletName).append("</h3>");
            this.errorString.append("<p>There were deployment problems with this portlet.</p>");
            this.errorString.append("<h4>Deployment errors:</h4>");
            for (String err : errors) {
                this.errorString.append("<div style='padding-left: 15px;'>");
                String[] lines = err.split("\\n");
                this.errorString.append(lines[0]);
                if (lines.length > 1) {
                    for (String line : Arrays.copyOfRange(lines, 1, lines.length)) {
                        this.errorString.append("<div style='padding-left: 15px;'>");
                        this.errorString.append(line);
                        this.errorString.append("</div>");
                    }
                }
                this.errorString.append(err.replaceAll("\\n", "<br/>"));
                this.errorString.append("</div>");
            }
        }
        resp.setContentType("text/html");
        PrintWriter writer = resp.getWriter();
        writer.write(this.errorString.toString());
    }

    private void formatToErrorString(String[] lines) {
        if (lines.length > 0) {
            this.errorString.append("<p style='color: #00F; font: bold;'>" + lines[0] + "</p>");
            for (String line : Arrays.copyOfRange(lines, 1, lines.length)) {
                Stack<String> closingTags = new Stack<String>();
                this.errorString.append("<div style='padding-left: 15px;'>");
                closingTags.push("</div>");
                while (line.length() > 0 && line.startsWith("\t")) {
                    this.errorString.append("<div style='padding-left: 15px;'>");
                    closingTags.push("</div>");
                    line = line.substring(1);
                }
                this.errorString.append(line);
                while (!closingTags.empty()) {
                    this.errorString.append((String)closingTags.pop());
                }
            }
        }
    }
}

