/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.mvc;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.servlet.ServletContext;

@Alternative
@ApplicationScoped
@Priority(value=2010)
public class ServletContextProducer {
    private Set<ServletContext> servletContexts = new HashSet<ServletContext>();

    public void applicationScopedInitialized(@Initialized(value=ApplicationScoped.class) @Observes ServletContext servletContext) {
        this.servletContexts.add(servletContext);
    }

    @Produces
    public ServletContext getServletContext() {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        for (ServletContext servletContext : this.servletContexts) {
            if (!contextClassLoader.equals(servletContext.getClassLoader())) continue;
            return servletContext;
        }
        return null;
    }
}

