/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.mvc;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Priority;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.mvc.View;
import javax.mvc.event.MvcEvent;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.MutableRenderParameters;
import javax.portlet.MutableResourceParameters;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.ResourceResponse;
import javax.portlet.annotations.ActionMethod;
import javax.portlet.annotations.DestroyMethod;
import javax.portlet.annotations.EventMethod;
import javax.portlet.annotations.InitMethod;
import javax.portlet.annotations.RenderMethod;
import javax.portlet.filter.RenderURLWrapper;
import javax.portlet.filter.ResourceURLWrapper;
import org.apache.pluto.container.bean.mvc.AfterControllerEventImpl;
import org.apache.pluto.container.bean.mvc.BeforeControllerEventImpl;
import org.apache.pluto.container.bean.mvc.ControllerInterceptorBinding;
import org.apache.pluto.container.bean.mvc.ControllerRedirectEventImpl;
import org.apache.pluto.container.bean.mvc.ResourceInfoImpl;
import org.apache.pluto.container.bean.mvc.UriInfoImpl;
import org.apache.pluto.container.bean.mvc.ViewRenderer;
import org.apache.pluto.container.bean.processor.MethodType;
import org.apache.pluto.container.bean.processor.PortletInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
@ControllerInterceptorBinding
@Priority(value=1000)
public class ControllerInterceptor
implements Serializable {
    private static final long serialVersionUID = 1573287230987622411L;
    private static final Logger LOG = LoggerFactory.getLogger(ControllerInterceptor.class);
    @Inject
    private ActionResponse actionResponse;
    @Inject
    private Event<MvcEvent> mvcEvent;
    @Inject
    private MimeResponse mimeResponse;
    @Inject
    private PortletConfig portletConfig;
    @Inject
    private PortletRequest portletRequest;
    @Inject
    private ResourceResponse resourceResponse;
    @Inject
    private ViewRenderer viewRenderer;

    @AroundInvoke
    public Object processView(InvocationContext invocationContext) throws Exception {
        PortletRequest portletRequest = this.portletRequest;
        MimeResponse mimeResponse = this.mimeResponse;
        String viewNameFromSession = null;
        Method invocationContextMethod = invocationContext.getMethod();
        MethodType methodType = this._getMethodType(invocationContextMethod);
        if (methodType == MethodType.RENDER || methodType == MethodType.RESOURCE) {
            Object[] parameters = invocationContext.getParameters();
            if (parameters != null && parameters.length > 1) {
                portletRequest = (PortletRequest)parameters[0];
                mimeResponse = (MimeResponse)parameters[1];
            }
            if (portletRequest.getParameter("redirectedView") != null) {
                PortletSession portletSession = portletRequest.getPortletSession(true);
                viewNameFromSession = (String)portletSession.getAttribute("viewName");
                portletSession.removeAttribute("viewName");
                if (viewNameFromSession != null) {
                    portletRequest.setAttribute("viewName", (Object)viewNameFromSession);
                }
            }
        }
        Object target = invocationContext.getTarget();
        this.mvcEvent.fire((Object)new BeforeControllerEventImpl(new ResourceInfoImpl(target.getClass(), invocationContextMethod), new UriInfoImpl()));
        Object result = invocationContext.proceed();
        Object redirectURL = null;
        boolean renderView = true;
        String viewName = null;
        if (this._isNull(result)) {
            View view = invocationContextMethod.getAnnotation(View.class);
            if (view != null) {
                viewName = view.value();
            }
        } else {
            viewName = result.toString();
        }
        if (!(this._isNull(viewName) || methodType != MethodType.ACTION && methodType != MethodType.RESOURCE)) {
            PortletSession portletSession = portletRequest.getPortletSession(true);
            if (viewName.startsWith("redirect:")) {
                viewName = viewName.substring("redirect:".length());
                redirectURL = methodType == MethodType.ACTION ? new ActionRedirectURL(this.actionResponse) : new ResourceRedirectURL(this.resourceResponse);
            }
            portletSession.setAttribute("viewName", (Object)viewName);
            if (methodType == MethodType.ACTION) {
                if (redirectURL == null) {
                    MutableRenderParameters mutableRenderParameters = this.actionResponse.getRenderParameters();
                    mutableRenderParameters.setValue("redirectedView", Boolean.TRUE.toString());
                } else {
                    try {
                        this.actionResponse.sendRedirect(redirectURL.toString());
                    }
                    catch (IOException ioe) {
                        LOG.error(ioe.getMessage(), (Throwable)ioe);
                    }
                }
            } else if (redirectURL != null) {
                this.resourceResponse.setStatus(302);
                this.resourceResponse.addProperty("Location", redirectURL.toString());
                renderView = false;
            }
        }
        if (renderView) {
            if (this._isNull(viewName)) {
                viewName = viewNameFromSession;
            }
            if (!this._isNull(viewName)) {
                portletRequest.setAttribute("viewName", (Object)viewName);
            }
        }
        target = invocationContext.getTarget();
        this.mvcEvent.fire((Object)new AfterControllerEventImpl(new ResourceInfoImpl(target.getClass(), invocationContextMethod), new UriInfoImpl()));
        if (redirectURL != null) {
            try {
                URI location = new URI(redirectURL.toString());
                this.mvcEvent.fire((Object)new ControllerRedirectEventImpl(new ResourceInfoImpl(target.getClass(), invocationContextMethod), new UriInfoImpl(), location));
            }
            catch (URISyntaxException urise) {
                LOG.error(urise.getMessage(), (Throwable)urise);
            }
        }
        if (viewName != null && portletRequest.getAttribute(PortletInvoker.LAST_METHOD) != null) {
            portletRequest.removeAttribute(PortletInvoker.LAST_METHOD);
            this.viewRenderer.render(portletRequest, mimeResponse, this.portletConfig);
        }
        return null;
    }

    private MethodType _getMethodType(Method invocationContextMethod) {
        if (invocationContextMethod.isAnnotationPresent(ActionMethod.class)) {
            return MethodType.ACTION;
        }
        if (invocationContextMethod.isAnnotationPresent(DestroyMethod.class)) {
            return MethodType.DESTROY;
        }
        if (invocationContextMethod.isAnnotationPresent(EventMethod.class)) {
            return MethodType.EVENT;
        }
        if (invocationContextMethod.isAnnotationPresent(InitMethod.class)) {
            return MethodType.INIT;
        }
        if (invocationContextMethod.isAnnotationPresent(RenderMethod.class)) {
            return MethodType.RENDER;
        }
        return MethodType.RESOURCE;
    }

    private boolean _isNull(Object viewName) {
        return viewName == null || viewName.toString().trim().toLowerCase().equals("null");
    }

    private static class ResourceRedirectURL
    extends ResourceURLWrapper {
        public ResourceRedirectURL(ResourceResponse resourceResponse) {
            super(resourceResponse.createResourceURL());
            MutableResourceParameters mutableResourceParameters = this.getResourceParameters();
            mutableResourceParameters.setValue("redirectedView", Boolean.TRUE.toString());
            this.setResourceID(null);
        }
    }

    private static class ActionRedirectURL
    extends RenderURLWrapper {
        public ActionRedirectURL(ActionResponse actionResponse) {
            super(actionResponse.createRedirectURL(MimeResponse.Copy.ALL));
            MutableRenderParameters mutableRenderParameters = this.getRenderParameters();
            mutableRenderParameters.setValue("redirectedView", Boolean.TRUE.toString());
        }
    }
}

