/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.portlet.ActionParameters;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.HeaderPortlet;
import javax.portlet.HeaderRequest;
import javax.portlet.HeaderResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.annotations.HeaderMethod;
import javax.portlet.annotations.RenderMethod;
import javax.portlet.annotations.ServeResourceMethod;
import javax.servlet.DispatcherType;
import javax.xml.namespace.QName;
import org.apache.pluto.container.bean.processor.AnnotatedConfigBean;
import org.apache.pluto.container.bean.processor.AnnotatedMethod;
import org.apache.pluto.container.bean.processor.AnnotatedMethodStore;
import org.apache.pluto.container.bean.processor.MethodDescription;
import org.apache.pluto.container.bean.processor.MethodIdentifier;
import org.apache.pluto.container.bean.processor.MethodType;
import org.apache.pluto.container.bean.processor.SignatureVariant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletInvoker
implements Portlet,
ResourceServingPortlet,
EventPortlet,
HeaderPortlet {
    public static final String LAST_METHOD = PortletInvoker.class.getName() + ".LAST_METHOD";
    private static final Logger LOG = LoggerFactory.getLogger(PortletInvoker.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private final AnnotatedMethodStore methodStore;
    private final String portletName;
    private PortletConfig config;

    public PortletInvoker(AnnotatedMethodStore methodStore, String portletName) {
        this.methodStore = methodStore;
        this.portletName = portletName;
    }

    public PortletInvoker(AnnotatedConfigBean acb, String portletName) {
        this.methodStore = acb.getMethodStore();
        this.portletName = portletName;
    }

    public PortletInvoker(AnnotatedMethodStore ams, String portlet, PortletConfig config) {
        this(ams, portlet);
        this.config = config;
    }

    private List<AnnotatedMethod> getMethods(MethodIdentifier mi) {
        Object id;
        List<AnnotatedMethod> meths;
        if (isDebug) {
            LOG.debug("Retrieving method for method identifier: " + mi.toString());
        }
        if ((meths = this.methodStore.getMethods(mi)).isEmpty() && (id = mi.getId()) != null && id instanceof String && ((String)id).length() > 0) {
            mi.setId("");
            if (isDebug) {
                LOG.debug("Retrying retrieval with method identifier: " + mi.toString());
            }
            meths = this.methodStore.getMethods(mi);
        }
        return meths;
    }

    private Object invokePortletMethod(AnnotatedMethod meth, Object ... args) throws PortletException, IOException {
        Object result;
        try {
            result = meth.invoke(args);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t != null) {
                if (t instanceof PortletException) {
                    throw (PortletException)t;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
            }
            String msg = "Problem invoking " + meth.toString() + ". Unknown InvocationTargetException Cause. ";
            throw new PortletException(msg, (Throwable)ite);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            String msg = "Problem invoking " + meth.toString() + ". ";
            throw new PortletException(msg + e.getMessage());
        }
        return result;
    }

    public void init(PortletConfig config) throws PortletException {
        this.config = config;
        MethodIdentifier mi = new MethodIdentifier(this.portletName, "", MethodType.INIT);
        List<AnnotatedMethod> meths = this.getMethods(mi);
        if (meths.size() == 0) {
            if (isDebug) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Init method not found for portlet: ").append(this.portletName);
                LOG.debug(txt.toString());
            }
            return;
        }
        assert (meths.size() == 1);
        AnnotatedMethod meth = meths.get(0);
        Object[] args = new Object[]{config};
        try {
            this.invokePortletMethod(meth, args);
        }
        catch (Throwable t) {
            throw new PortletException("Portlet could not be initialized.", t);
        }
    }

    public void destroy() {
        MethodIdentifier mi = new MethodIdentifier(this.portletName, "", MethodType.DESTROY);
        List<AnnotatedMethod> meths = this.getMethods(mi);
        if (meths.size() == 0) {
            if (isDebug) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Destroy method not found for portlet: ").append(this.portletName);
                LOG.debug(txt.toString());
            }
            return;
        }
        assert (meths.size() == 1);
        AnnotatedMethod meth = meths.get(0);
        Object[] args = new Object[]{};
        try {
            this.invokePortletMethod(meth, args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void serveResource(ResourceRequest req, ResourceResponse resp) throws PortletException, IOException {
        String id = req.getResourceID() != null ? req.getResourceID() : "";
        MethodIdentifier mi = new MethodIdentifier(this.portletName, id, MethodType.RESOURCE);
        List<Object> meths = new ArrayList();
        if (req.getDispatcherType() == DispatcherType.ASYNC) {
            AnnotatedMethod meth = (AnnotatedMethod)req.getAttribute("javax.portlet.asyncMethod");
            if (meth == null) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Async processing error. ServeResource method attribute could not be retrieved.");
                LOG.error(txt.toString());
                return;
            }
            LOG.debug("Processing async dispatch. method: " + meth.toString());
            meths.add(meth);
        } else {
            meths = this.getMethods(mi);
        }
        int totalMethods = meths.size();
        if (totalMethods == 0) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("ServeResource method not found. Resource ID=\"").append(id).append("\"");
            LOG.warn(txt.toString());
            return;
        }
        for (int i = 0; i < totalMethods; ++i) {
            AnnotatedMethod meth;
            ServeResourceMethod rm;
            if (i == totalMethods - 1) {
                req.setAttribute(LAST_METHOD, (Object)Boolean.TRUE);
            }
            if ((rm = (ServeResourceMethod)(meth = (AnnotatedMethod)meths.get(i)).getAnnotation()) != null) {
                if (rm.characterEncoding().length() > 0) {
                    resp.setCharacterEncoding(rm.characterEncoding());
                }
                if (!rm.contentType().matches("(^$|\\*|\\*/\\*|text/\\*)")) {
                    resp.setContentType(rm.contentType());
                }
            }
            Object[] args = new Object[]{};
            MethodDescription methDescription = meth.getDescription();
            SignatureVariant signatureVariant = methDescription.getVariant();
            if (signatureVariant == SignatureVariant.STRING_RESOURCEREQ_RESOURCERESP || signatureVariant == SignatureVariant.VOID_RESOURCEREQ_RESOURCERESP) {
                args = new Object[]{req, resp};
            }
            Object result = this.invokePortletMethod(meth, args);
            if (req.isAsyncStarted()) {
                LOG.debug("Async processing was started during method: " + meth.toString());
                req.setAttribute("javax.portlet.asyncMethod", (Object)meth);
                break;
            }
            if (signatureVariant == SignatureVariant.STRING_VOID && result != null) {
                assert (result instanceof String);
                resp.getWriter().write((String)result);
            }
            if (rm == null || rm.include().length() <= 0) continue;
            PortletRequestDispatcher prd = this.config.getPortletContext().getRequestDispatcher(rm.include());
            prd.include((PortletRequest)req, (PortletResponse)resp);
        }
    }

    public void processEvent(EventRequest req, EventResponse resp) throws PortletException, IOException {
        QName qn = req.getEvent().getQName();
        MethodIdentifier mi = new MethodIdentifier(this.portletName, qn, MethodType.EVENT);
        List<AnnotatedMethod> meths = this.getMethods(mi);
        if (meths.size() == 0) {
            mi.setId("");
            meths = this.getMethods(mi);
            if (meths.size() == 0) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Event method not found. Event qname=").append(qn);
                LOG.warn(txt.toString());
                return;
            }
        }
        assert (meths.size() == 1);
        AnnotatedMethod meth = meths.get(0);
        Object[] args = new Object[]{req, resp};
        this.invokePortletMethod(meth, args);
    }

    public void processAction(ActionRequest req, ActionResponse resp) throws PortletException, IOException {
        String id;
        MethodIdentifier mi;
        List<AnnotatedMethod> meths;
        ActionParameters actionParameters = req.getActionParameters();
        String an = actionParameters.getValue("javax.portlet.action");
        if (an == null) {
            an = actionParameters.getValue(resp.getNamespace() + "javax.portlet.action");
        }
        if ((meths = this.getMethods(mi = new MethodIdentifier(this.portletName, id = an != null ? an : "", MethodType.ACTION))).size() == 0) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Action method not found. Action name=\"").append(an).append("\"");
            LOG.warn(txt.toString());
            return;
        }
        assert (meths.size() == 1);
        AnnotatedMethod meth = meths.get(0);
        Object[] args = new Object[]{req, resp};
        this.invokePortletMethod(meth, args);
    }

    public void render(RenderRequest req, RenderResponse resp) throws PortletException, IOException {
        String pm;
        String id;
        MethodIdentifier mi;
        List<AnnotatedMethod> meths;
        ResourceBundle resourceBundle = this.config.getResourceBundle(req.getLocale());
        if (isDebug) {
            LOG.debug("PLUTO-765 resourceBundle={}", (Object)resourceBundle);
        }
        if ((meths = this.getMethods(mi = new MethodIdentifier(this.portletName, id = (pm = req.getPortletMode().toString()) != null ? pm.toUpperCase() : "", MethodType.RENDER))).isEmpty()) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Render method not found. Portlet mode: \"").append(pm).append("\"");
            LOG.warn(txt.toString());
            return;
        }
        int totalMethods = meths.size();
        for (int i = 0; i < totalMethods; ++i) {
            AnnotatedMethod meth;
            RenderMethod rm;
            if (i == totalMethods - 1) {
                req.setAttribute(LAST_METHOD, (Object)Boolean.TRUE);
            }
            if ((rm = (RenderMethod)(meth = meths.get(i)).getAnnotation()) != null && !rm.contentType().matches("(^$|\\*|\\*/\\*|text/\\*)")) {
                resp.setContentType(rm.contentType());
            }
            Object[] args = new Object[]{};
            MethodDescription methodDescription = meth.getDescription();
            SignatureVariant variant = methodDescription.getVariant();
            if (variant == SignatureVariant.STRING_RENDERREQ_RENDERRESP || variant == SignatureVariant.VOID_RENDERREQ_RENDERRESP) {
                args = new Object[]{req, resp};
            }
            Object result = this.invokePortletMethod(meth, args);
            if (variant == SignatureVariant.STRING_VOID && result != null) {
                assert (result instanceof String);
                resp.getWriter().write((String)result);
            }
            if (rm == null || rm.include().length() <= 0) continue;
            PortletRequestDispatcher prd = this.config.getPortletContext().getRequestDispatcher(rm.include());
            prd.include(req, resp);
        }
    }

    public void renderHeaders(HeaderRequest req, HeaderResponse resp) throws PortletException, IOException {
        String pm = req.getPortletMode().toString();
        String id = pm != null ? pm.toUpperCase() : "";
        MethodIdentifier mi = new MethodIdentifier(this.portletName, id, MethodType.HEADER);
        List<AnnotatedMethod> meths = this.getMethods(mi);
        if (meths.isEmpty()) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Header method not found. Portlet mode: \"").append(pm).append("\"");
            LOG.warn(txt.toString());
            return;
        }
        for (AnnotatedMethod meth : meths) {
            HeaderMethod hm = (HeaderMethod)meth.getAnnotation();
            if (hm != null && !hm.contentType().matches("(^$|\\*|\\*/\\*|text/\\*)")) {
                resp.setContentType(hm.contentType());
            }
            Object[] args = new Object[]{};
            if (meth.getDescription().getVariant() == SignatureVariant.VOID_HEADERREQ_HEADERRESP) {
                args = new Object[]{req, resp};
            }
            Object result = this.invokePortletMethod(meth, args);
            if (meth.getDescription().getVariant() == SignatureVariant.STRING_VOID && result != null) {
                assert (result instanceof String);
                resp.getWriter().write((String)result);
            }
            if (hm == null || hm.include().length() <= 0) continue;
            PortletRequestDispatcher prd = this.config.getPortletContext().getRequestDispatcher(hm.include());
            prd.include((PortletRequest)req, (PortletResponse)resp);
        }
    }
}

