/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import eu.infomas.annotation.AnnotationDetector;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.annotations.ActionMethod;
import javax.portlet.annotations.DestroyMethod;
import javax.portlet.annotations.EventMethod;
import javax.portlet.annotations.HeaderMethod;
import javax.portlet.annotations.InitMethod;
import javax.portlet.annotations.RenderMethod;
import javax.portlet.annotations.ServeResourceMethod;
import javax.servlet.ServletContext;
import org.apache.pluto.container.bean.processor.AnnotatedMethodStore;
import org.apache.pluto.container.bean.processor.ConfigSummary;
import org.apache.pluto.container.bean.processor.PortletAnnotationRecognizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodAnnotationRecognizer
extends PortletAnnotationRecognizer
implements AnnotationDetector.MethodReporter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodAnnotationRecognizer.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private static final String CLASSDIR = "/WEB-INF/classes";
    private static final String LIBDIR = "/WEB-INF/lib";
    private AnnotationDetector ad;
    private Set<String> handledClasses = new HashSet<String>();

    public MethodAnnotationRecognizer(AnnotatedMethodStore pms, ConfigSummary summary) {
        this(pms, summary, true);
    }

    public MethodAnnotationRecognizer(AnnotatedMethodStore pms, ConfigSummary summary, boolean mvc) {
        super(pms, summary, mvc);
        this.ad = new AnnotationDetector((AnnotationDetector.Reporter)this);
    }

    public Class<? extends Annotation>[] annotations() {
        return new Class[]{HeaderMethod.class, ActionMethod.class, EventMethod.class, RenderMethod.class, ServeResourceMethod.class, InitMethod.class, DestroyMethod.class};
    }

    public void reportMethodAnnotation(Class<? extends Annotation> anno, String className, String methName) {
        if (!this.handledClasses.contains(className)) {
            this.handledClasses.add(className);
            Class<?> valClass = null;
            StringBuilder txt = new StringBuilder(128);
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = this.getClass().getClassLoader();
                }
                valClass = cl.loadClass(className);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isDebug) {
                txt.append("Found: ").append(anno.getSimpleName());
                txt.append(", class name: ").append(className);
                txt.append(", method name: ").append(methName);
                txt.append(", class: ").append(valClass == null ? "could not be loaded." : "loaded.");
                LOG.debug(txt.toString());
            }
            if (valClass != null) {
                this.checkForMethodAnnotations(valClass);
            }
        }
    }

    public void scanContext(ServletContext ctx) {
        Set<File> files = this.getClassFilesForPath(ctx, CLASSDIR);
        this.scanFiles(files);
        files = this.getLibFilesForPath(ctx, LIBDIR);
        this.scanFiles(files);
    }

    public void scanFiles(Set<File> files) {
        long start = System.currentTimeMillis();
        try {
            this.ad.detect(files.toArray(new File[0]));
        }
        catch (IOException e) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Exception scanning for method annotations.");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            txt.append(sw.toString());
            LOG.warn(txt.toString());
        }
        long delta = System.currentTimeMillis() - start;
        if (isDebug) {
            StringBuilder txt = new StringBuilder();
            txt.append("Scanned ").append(files.size()).append(" files.");
            txt.append(" Time: ").append(delta).append(" ms.");
            txt.append("Files: ");
            String sep = "";
            for (File file : files) {
                txt.append(sep).append(file.toString());
                sep = ", ";
            }
            LOG.debug(txt.toString());
        }
    }

    private Set<File> getClassFilesForPath(ServletContext ctx, String path) {
        HashSet<File> files = new HashSet<File>();
        Set paths = ctx.getResourcePaths(path);
        if (paths != null) {
            for (String pth : paths) {
                if (pth.endsWith("META-INF/")) continue;
                if (pth.endsWith("/")) {
                    files.addAll(this.getClassFilesForPath(ctx, pth));
                    continue;
                }
                if (!pth.endsWith(".class")) continue;
                try {
                    URL url = ctx.getResource(pth);
                    File f = new File(url.toURI());
                    files.add(f);
                }
                catch (Exception e) {
                    StringBuilder txt = new StringBuilder(128);
                    txt.append("Exception getting library file.");
                    txt.append(" Servlet context path: ").append(ctx.getContextPath());
                    txt.append(", File path: ").append(path).append("\n");
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    pw.flush();
                    txt.append(sw.toString());
                    LOG.warn(txt.toString());
                }
            }
        }
        return files;
    }

    private Set<File> getLibFilesForPath(ServletContext ctx, String path) {
        HashSet<File> files = new HashSet<File>();
        Set libs = ctx.getResourcePaths(path);
        if (libs != null) {
            for (String lib : libs) {
                if (!lib.endsWith(".jar")) continue;
                try {
                    URL url = ctx.getResource(lib);
                    File f = new File(url.toURI());
                    files.add(f);
                }
                catch (Exception e) {
                    StringBuilder txt = new StringBuilder(128);
                    txt.append("Exception getting library file.");
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    pw.flush();
                    txt.append(sw.toString());
                    LOG.warn(txt.toString());
                }
            }
        }
        return files;
    }
}

