/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.assemble.ear;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

abstract class AssemblySink
extends FilterOutputStream {
    protected static int DEFAULT_BUFLEN = 4096;
    protected final Checksum CRC = new CRC32();
    protected long count = 0L;

    AssemblySink() {
        super(null);
    }

    AssemblySink(OutputStream out) {
        super(out);
    }

    long getByteCount() {
        return this.count;
    }

    long getCrc() {
        return this.CRC.getValue();
    }

    void writeTo(OutputStream out) throws IOException {
        this.writeTo(out, DEFAULT_BUFLEN);
    }

    abstract void writeTo(OutputStream var1, int var2) throws IOException;

    @Override
    public synchronized void write(byte[] b) throws IOException {
        try {
            this.out.write(b);
            ++this.count;
            this.CRC.update(b, 0, b.length);
        }
        catch (IOException e) {
            this.count = 0L;
            this.CRC.reset();
            throw e;
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        try {
            this.out.write(b, off, len);
            this.count += (long)len;
            this.CRC.update(b, off, len);
        }
        catch (IOException e) {
            this.count = 0L;
            this.CRC.reset();
            throw e;
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        try {
            this.out.write(b);
            ++this.count;
            this.CRC.update(b);
        }
        catch (IOException e) {
            this.count = 0L;
            this.CRC.reset();
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.close();
        }
        finally {
            this.CRC.reset();
            this.count = 0L;
        }
    }
}

