/*  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.portals.pluto.demo.integration.test;

import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

/**
 *
 * @author Kyle Stiemann
 */
public final class WaitingAsserter {

   private final WebDriverWait webDriverWait;

   public WaitingAsserter(WebDriver driver, long timeOutInSeconds) {
      this.webDriverWait = new WebDriverWait(driver, timeOutInSeconds);
   }

   public void assertTrue(ExpectedCondition expectedCondition) {

      try {
         waitFor(expectedCondition);
      } catch (TimeoutException e) {
         throw new AssertionError(e);
      }
   }

   public void waitFor(ExpectedCondition expectedCondition) {
      webDriverWait.until(expectedCondition);
   }
}
