/*  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

/**
 * This bean encapsulates a single test result. When converted to a string or 
 * written to a writer, it generates HTML markup containing elements and IDs
 * that can be read by the TCK test driver. 
 * 
 * The TCK test driver works by accessing the page containing the test portlet,
 * clicking a link for the test if one is present, and reading the test output.
 * 
 * The test case is identified by a unique name string that contains no blanks. 
 * The test case name is used to generate ID's for the HTML result elements.
 * The following IDs are generated by this bean:
 * 
 * (TestCaseName)-success     - indicates general test case success or failure
 * (TestCaseName)-detail      - a detailed message about the test     
 * 
 */
package javax.portlet.tck.beans;

import java.io.IOException;
import java.io.Writer;

/**
 * Displays a message for a test case, for example when waiting for results.
 * 
 * @author nick
 */
public class TestMessage {

   private String tcName;
   private String msg;

   /**
    * Creates an empty test result.
    */
   public TestMessage() {
      tcName = "";
      msg = "";
   }

   /**
    * Creates a test message initialized according to the parameters.
    * 
    * @param tcName
    *           test case name
    * @param msg
    *           message to be displayed
    */
   public TestMessage(String tcName, String msg) {
      this.tcName = tcName;
      this.msg = msg;
   }

   /**
    * Generates HTML markup representing the test message.
    * 
    * @return HTML markup representing the test message
    */
   @Override
   public String toString() {

      StringBuilder sb = new StringBuilder();
      sb.append("<div class='portletTCKTestcase'>\n");
      sb.append("<h4>\n");
      sb.append(tcName);
      sb.append(" message:");
      sb.append("</h4>\n");
      sb.append("<p>\n");
      sb.append(msg);
      sb.append("</p>\n");
      sb.append("</div>\n");

      return sb.toString();
   }

   /**
    * Generates HTML markup representing the test link and writes them to the writer provided.
    * 
    * @param writer
    *           Writer to which the string is written
    */
   public void writeTo(Writer writer) throws IOException {
      writer.write(this.toString());
   }

}
