/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.assemble;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.pluto.util.UtilityException;
import org.apache.pluto.util.assemble.AssemblerConfig;
import org.apache.pluto.util.assemble.WebXmlRewritingAssembler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArchiveAssembler
extends WebXmlRewritingAssembler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractArchiveAssembler.class);

    public void assemble(AssemblerConfig config) throws UtilityException {
        File source = config.getSource();
        File dest = config.getDestination();
        try {
            if (source == null || !source.exists()) {
                throw new UtilityException("Source archive doesn't exist.");
            }
            if (source.isDirectory()) {
                throw new UtilityException("Source archive is a directory.");
            }
            if (this.performInPlaceAssembly(config)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Performing in-place assembly of " + config.getSource().getAbsolutePath());
                }
                dest = File.createTempFile(source.getName(), ".tmp");
                config.setDestination(dest);
                this.assembleInternal(config);
                boolean success = dest.renameTo(source);
                if (!success) {
                    FileUtils.copyFile((File)dest, (File)source);
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Performing assembly of " + config.getSource().getAbsolutePath() + " to " + config.getDestination().getAbsolutePath());
                }
                File destFile = dest;
                if (dest.isDirectory()) {
                    dest.mkdirs();
                    destFile = new File(dest, source.getName());
                }
                config.setDestination(destFile);
                this.assembleInternal(config);
            }
        }
        catch (IOException e) {
            LOG.error("Assembly failed: " + e.getMessage());
            throw new UtilityException(e.getMessage(), e);
        }
    }

    protected boolean performInPlaceAssembly(AssemblerConfig config) {
        if (config.getDestination() == null) {
            return true;
        }
        if (config.getDestination().equals(config.getSource())) {
            return true;
        }
        return config.getDestination().equals(config.getSource().getParentFile());
    }

    protected abstract void assembleInternal(AssemblerConfig var1) throws UtilityException, IOException;
}

