/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.renderer.AntOutputRenderer;
import org.tp23.antinstaller.renderer.RendererFactory;
import org.tp23.antinstaller.renderer.text.AbstractTextPageRenderer;
import org.tp23.antinstaller.renderer.text.TextMessageRenderer;
import org.tp23.antinstaller.runtime.AntRunner;
import org.tp23.antinstaller.runtime.IfPropertyHelper;
import org.tp23.antinstaller.runtime.Logger;
import org.tp23.antinstaller.runtime.Runner;

public class TextRunner
extends AntRunner
implements Runner {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    protected final InstallerContext ctx;
    protected final Installer installer;
    private final Logger logger;
    protected final IfPropertyHelper ifHelper;

    public TextRunner(InstallerContext ctx) throws IOException {
        super(ctx);
        this.ctx = ctx;
        this.installer = ctx.getInstaller();
        this.logger = ctx.getLogger();
        ctx.setMessageRenderer(new TextMessageRenderer());
        ctx.setAntOutputRenderer(new AntOutputRenderer(){

            public PrintStream getErr() {
                return System.err;
            }

            public PrintStream getOut() {
                return System.out;
            }
        });
        this.ifHelper = new IfPropertyHelper(ctx);
    }

    public boolean runInstaller() throws InstallException {
        try {
            return this.renderPages(this.installer.getPages());
        }
        catch (Exception ex) {
            this.logger.log("FATAL exception during installation:" + ex.getMessage());
            this.logger.log(this.installer, ex);
            this.ctx.getMessageRenderer().printMessage(res.getString("installationFailed") + ":" + ex.getMessage());
            throw new InstallException("Installation failed", ex);
        }
    }

    private boolean renderPages(Page[] pages) throws ClassNotFoundException, InstallException {
        Page next = null;
        for (int i = 0; i < pages.length; ++i) {
            next = pages[i];
            if (next instanceof SimpleInputPage && (!this.ifHelper.ifTarget(next, pages) || !this.ifHelper.ifProperty(next))) continue;
            AbstractTextPageRenderer renderer = RendererFactory.getTextPageRenderer(next);
            renderer.setContext(this.ctx);
            renderer.init(new BufferedReader(new InputStreamReader(System.in)), System.out);
            this.ctx.setCurrentPage(next);
            renderer.renderPage(next);
            if (next.isAbort()) {
                return false;
            }
            this.runPost(next);
        }
        return true;
    }

    public InstallerContext getInstallerContext() {
        return this.ctx;
    }

    public void antFinished() {
        System.out.println(res.getString("finished"));
    }

    public void fatalError() {
        System.out.println(res.getString("failed"));
    }

    public String toString() {
        return "TextRunner";
    }
}

