/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.polygene.serialization.messagepack;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.polygene.api.type.ValueType;
import org.apache.polygene.spi.serialization.SerializationSettings;

public class MessagePackSettings extends SerializationSettings<MessagePackSettings>
{
    public static final MessagePackSettings DEFAULT = new MessagePackSettings();

    public static MessagePackSettings orDefault( MessagePackSettings settings )
    {
        return settings != null ? settings : DEFAULT;
    }

    private Map<ValueType, MessagePackAdapter<?>> adapters;

    public MessagePackSettings()
    {
        adapters = new LinkedHashMap<>();
    }

    public Map<ValueType, MessagePackAdapter<?>> getAdapters()
    {
        return adapters;
    }
}
