/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *
 */
package org.apache.polygene.index.rdf.qi64;

import org.apache.polygene.api.entity.EntityBuilder;
import org.apache.polygene.api.identity.Identity;
import org.apache.polygene.api.unitofwork.UnitOfWork;
import org.apache.polygene.api.unitofwork.UnitOfWorkCompletionException;
import org.apache.polygene.bootstrap.AssemblyException;
import org.apache.polygene.bootstrap.ModuleAssembly;
import org.apache.polygene.library.rdf.repository.MemoryRepositoryService;
import org.apache.polygene.test.AbstractPolygeneTest;
import org.apache.polygene.test.EntityTestAssembler;

public abstract class AbstractIssueTest
    extends AbstractPolygeneTest
{
    private static final String DEFAULT_ACCOUNT_NAME = "polygene";

    /**
     * Creates a new Apaxhe Polygene account.
     *
     * @return The new account reference.
     *
     * @throws org.apache.polygene.api.unitofwork.UnitOfWorkCompletionException
     *          Thrown if creational fail.
     */
    protected final Identity newPolygeneAccount()
        throws UnitOfWorkCompletionException
    {
        UnitOfWork work = unitOfWorkFactory.newUnitOfWork();
        EntityBuilder<AccountComposite> entityBuilder = work.newEntityBuilder( AccountComposite.class );
        AccountComposite accountComposite = entityBuilder.instance();
        accountComposite.name().set( DEFAULT_ACCOUNT_NAME );
        accountComposite = entityBuilder.newInstance();

        Identity identity = accountComposite.identity().get();
        work.complete();
        return identity;
    }

    public final void assemble( ModuleAssembly aModuleAssembly )
        throws AssemblyException
    {
        aModuleAssembly.entities( AccountComposite.class );
        new EntityTestAssembler().assemble( aModuleAssembly );
        aModuleAssembly.services( MemoryRepositoryService.class );
        onAssemble( aModuleAssembly );
    }

    protected abstract void onAssemble( ModuleAssembly aModuleAssembly )
        throws AssemblyException;
}
