/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *
 */

package org.apache.polygene.regression.qi230;

import org.apache.polygene.test.AbstractPolygeneTest;
import org.junit.Test;
import org.apache.polygene.api.PolygeneAPI;
import org.apache.polygene.api.composite.Composite;
import org.apache.polygene.api.concern.ConcernOf;
import org.apache.polygene.api.concern.Concerns;
import org.apache.polygene.api.injection.scope.Service;
import org.apache.polygene.api.injection.scope.Structure;
import org.apache.polygene.api.injection.scope.This;
import org.apache.polygene.api.mixin.Mixins;
import org.apache.polygene.api.mixin.NoopMixin;
import org.apache.polygene.api.service.ServiceComposite;
import org.apache.polygene.bootstrap.AssemblyException;
import org.apache.polygene.bootstrap.ModuleAssembly;

import static org.junit.Assert.assertEquals;

/**
 * JAVADOC
 */
public class Qi230IssueTest
    extends AbstractPolygeneTest
{
    public void assemble( ModuleAssembly module )
        throws AssemblyException
    {
        module.services( Some.class ).withMixins( NoopMixin.class ).withConcerns( OtherConcern.class );
//        module.services( Some.class );
        module.services( Result.class );
    }

    @Test
    public void whenDerefencingInsideConcernThisExpectItToWork()
        throws Exception
    {
        Result result = serviceFinder.findService( Result.class ).get();
        Some some = serviceFinder.findService( Some.class ).get();
        assertEquals( "method()", some.method() );
        assertEquals( some.identity(), result.some().identity() );
        assertEquals( some.identity().get(), result.some().identity().get() );
    }

    @Mixins( ResultMixin.class )
    public interface Result
        extends ServiceComposite
    {
        void execute( Some value );

        Some some();
    }

    public static abstract class ResultMixin
        implements Result
    {

        private Some value;

        public void execute( Some value )
        {
            this.value = value;
        }

        public Some some()
        {
            return value;
        }
    }

    @Concerns( OtherConcern.class )
    @Mixins( NoopMixin.class )
    public interface Other
    {
        void other();
    }

    @Mixins( SomeMixin.class )
    public interface Some
        extends ServiceComposite
//        extends ServiceComposite, Other
    {
        String method();
    }

    public abstract static class SomeMixin
        implements Some
    {
        @This
        private Other other;

        public String method()
        {
            other.other();
            return "method()";
        }
    }

    public static class OtherConcern
        extends ConcernOf<Other>
        implements Other
    {
        @Structure
        private PolygeneAPI api;

        @This
        private Composite me;

        @Service
        private Result result;

        public void other()
        {
            Composite value = api.dereference( me );
            result.execute( (Some) value );
            next.other();
        }
    }
}
