/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *
 */

package org.apache.polygene.bootstrap;

/**
 * Base class for assembly visitors. Subclass and override
 * the particular methods you are interested in.
 */
public class AssemblyVisitorAdapter<ThrowableType extends Throwable>
    implements AssemblyVisitor<ThrowableType>
{
    @Override
    public void visitApplication( ApplicationAssembly assembly )
        throws ThrowableType
    {
    }

    @Override
    public void visitLayer( LayerAssembly assembly )
        throws ThrowableType
    {
    }

    @Override
    public void visitModule( ModuleAssembly assembly )
        throws ThrowableType
    {
    }

    @Override
    public void visitComposite( TransientDeclaration declaration )
        throws ThrowableType
    {
    }

    @Override
    public void visitEntity( EntityDeclaration declaration )
        throws ThrowableType
    {
    }

    @Override
    public void visitService( ServiceDeclaration declaration )
        throws ThrowableType
    {
    }

    @Override
    public void visitImportedService( ImportedServiceDeclaration declaration )
        throws ThrowableType
    {
    }

    @Override
    public void visitValue( ValueDeclaration declaration )
        throws ThrowableType
    {
    }

    @Override
    public void visitObject( ObjectDeclaration declaration )
        throws ThrowableType
    {
    }
}
