
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.w3c.dom.*;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
* 

    The "setAttributeNodeNS(namespaceURI,qualifiedName,value)" method for an attribute causes the 

   DOMException NO_MODIFICATION_ALLOWED_ERR to be raised

   if the node is readonly.

   

   Obtain the children of the THIRD "gender" element.  The elements

   content is an entity reference.  Try to set an attribute

   in the entity reference by executing the 

   "setAttributeNodeNS(newAttr)" method.

   This causes a NO_MODIFICATION_ALLOWED_ERR DOMException to be thrown.


*
 *@freq weekly
*
 *@freq weekly
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-258A00AF')/constant[@name='NO_MODIFICATION_ALLOWED_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-258A00AF')/constant[@name='NO_MODIFICATION_ALLOWED_ERR'])</a>
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS</a>
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-ElSetAtNodeNS')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NO_MODIFICATION_ALLOWED_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-ElSetAtNodeNS')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NO_MODIFICATION_ALLOWED_ERR'])</a>
*/
public class setAttributeNodeNS02 extends DOMTestCase {public setAttributeNodeNS02(String name){super(name);	}public static Test suite() {	return new TestSuite(setAttributeNodeNS02.class);	}

   /**
    * Constructor
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public setAttributeNodeNS02(DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.notNamespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

   }

   /**
    * Test body
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void testRun() throws Throwable {
      Document doc;
      NodeList genderList;
      Node gender;
      NodeList genList;
      Node gen;
      NodeList gList;
      Element genElement;
      Attr newAttr;
      Attr setAttr1;
      doc = (Document) load("staffNS", true);
      
      if (!isExpandEntityReferences()) {
          genderList = doc.getElementsByTagName("gender");
      gender = genderList.item(2);
      genList = gender.getChildNodes();
      gen = genList.item(0);
      } else {
          gen = doc.createEntityReference("ent4");
      }
        
    gList = gen.getChildNodes();
      genElement = (Element) gList.item(0);
      assertNotNull("notnull", genElement);
      newAttr = doc.createAttributeNS("www.xyz.com", "emp:local1");
      
      {
         boolean success = false;
         try {
            setAttr1 = genElement.setAttributeNodeNS(newAttr);
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
         }
         assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR", success);
      }

   }
   /**
    *  Gets URI that identifies the test
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/setAttributeNodeNS02";
   }
   /**
    * Runs individual test
    * @param args command line arguments
    */
   public static void main(String[] args) {
        DOMTestCase.doMain(setAttributeNodeNS02.class, args);
   }
}
