
/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

 /*
 $Log: JAXPDOMTestDocumentBuilderFactory.java,v $
 Revision 1.2  2003/04/24 05:02:05  dom-ts-4
 Xalan-J support for L3 XPath
 http://www.w3.org/Bugs/Public/show_bug.cgi?id=191

 Revision 1.1  2002/02/03 07:47:51  dom-ts-4
 More missing files

 */

package org.w3c.domts;

import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.domts.*;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

/**
 *   This class implements the generic parser and configuation
 *   abstract class for JAXP supporting parsers.
 */

public class JAXPDOMTestDocumentBuilderFactory
  extends DOMTestDocumentBuilderFactory {

  private DocumentBuilderFactory factory;
  private DocumentBuilder builder;

  /**
   * Creates a JAXP implementation of DOMTestDocumentBuilderFactory.
   * @param factory null for default JAXP provider.  If not null,
   * factory will be mutated in constructor and should be released
   * by calling code upon return.
   * @param settings array of settings, may be null.
   */
  public JAXPDOMTestDocumentBuilderFactory(
    DocumentBuilderFactory baseFactory,
    DocumentBuilderSetting[] settings)
    throws DOMTestIncompatibleException {
    super(settings);
    if(baseFactory == null) {
      factory = DocumentBuilderFactory.newInstance();
    }
    else {
      factory = baseFactory;
    }
    //
    //    apply settings to selected document builder
    //         may throw exception if incompatible
    if(settings != null) {
      for(int i = 0; i < settings.length; i++) {
        settings[i].applySetting(factory);
      }
    }
    try {
      this.builder = factory.newDocumentBuilder();
    }
    catch(ParserConfigurationException ex) {
      throw new DOMTestIncompatibleException(ex,null);
    }
  }

  protected DOMTestDocumentBuilderFactory createInstance(DocumentBuilderFactory newFactory,
    DocumentBuilderSetting[] mergedSettings)
    throws DOMTestIncompatibleException {
    return new JAXPDOMTestDocumentBuilderFactory(newFactory,mergedSettings);
  }

  public DOMTestDocumentBuilderFactory newInstance(DocumentBuilderSetting[] newSettings)
    throws DOMTestIncompatibleException {
    if(newSettings == null) {
      return this;
    }
    DocumentBuilderSetting[] mergedSettings = mergeSettings(newSettings);
    DocumentBuilderFactory newFactory = factory.newInstance();
    return createInstance(newFactory, mergedSettings);
  }

  private class LoadErrorHandler implements org.xml.sax.ErrorHandler {
    private SAXException parseException;
    private int errorCount;
    private int warningCount;
    public LoadErrorHandler() {
      parseException = null;
      errorCount = 0;
      warningCount = 0;
    }
    public void error(SAXParseException ex) {
      errorCount++;
      if(parseException == null) {
        parseException = ex;
      }
    }

    public void warning(SAXParseException ex) {
      warningCount++;
    }

    public void fatalError(SAXParseException ex) {
      if(parseException == null) {
        parseException = ex;
      }
    }

    public SAXException getFirstException() {
      return parseException;
    }
  }


 public Document load(java.net.URL url) throws DOMTestLoadException { return null; }
    /*
      if(url == null) {
        throw new NullPointerException("url");
      }
      //System.out.println("XML BEANS implementation");
      try{
	   dom.Loader _loader=  dom.Loader.getLoader();
	  _XBeanDoc= _loader.load(sXml);
      return  (org.w3c.dom.Document)com.bea.xbean.newstore.pub.Public.parse(url.toString(),backend);
      }catch (Exception e){
	  throw new DOMTestLoadException(e);
      }

 }
         */

  public DOMImplementation getDOMImplementation() {
    return builder.getDOMImplementation();
  }

  public boolean hasFeature(String feature, String version) {
    return builder.getDOMImplementation().hasFeature(feature,version);
  }


    public boolean isCoalescing() {
      return factory.isCoalescing();
    }

    public boolean isExpandEntityReferences() {
      return factory.isExpandEntityReferences();
    }

    public boolean isIgnoringElementContentWhitespace() {
      return factory.isIgnoringElementContentWhitespace();
    }

    public boolean isNamespaceAware() {
      return factory.isNamespaceAware();
    }

    public boolean isValidating() {
      return factory.isValidating();
    }

  public static DocumentBuilderSetting[] getConfiguration1()
  {
    return new DocumentBuilderSetting[] {
          DocumentBuilderSetting.notCoalescing,
          DocumentBuilderSetting.notExpandEntityReferences,
          DocumentBuilderSetting.notIgnoringElementContentWhitespace,
          DocumentBuilderSetting.notNamespaceAware,
          DocumentBuilderSetting.notValidating };
  }

  public static DocumentBuilderSetting[] getConfiguration2() {
      return new DocumentBuilderSetting[] {
          DocumentBuilderSetting.notCoalescing,
          DocumentBuilderSetting.expandEntityReferences,
          DocumentBuilderSetting.ignoringElementContentWhitespace,
          DocumentBuilderSetting.namespaceAware,
          DocumentBuilderSetting.validating };

  }


}

