
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
* 

    The "createElementNS(namespaceURI,qualifiedName)" method for a 

   Document should raise INVALID_CHARACTER_ERR DOMException if 

   qualifiedName contains an illegal character.

   

   Invoke method createElementNS(namespaceURI,qualifiedName) on this document

   with qualifiedName containing an illegal character from illegalChars[].

   Method should raise INVALID_CHARACTER_ERR DOMException for all characters

   in illegalChars[].


*
 *@freq weekly
*
 *@freq weekly
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrElNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrElNS</a>
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-DocCrElNS')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INVALID_CHARACTER_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-DocCrElNS')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INVALID_CHARACTER_ERR'])</a>
*/
public class createElementNS03 extends DOMTestCase {public createElementNS03(String name){super(name);	}public static Test suite() {	return new TestSuite(createElementNS03.class);	}

   /**
    * Constructor
    * @param factory document factory, may not be null
    */
   public createElementNS03(DOMTestDocumentBuilderFactory factory)  {
      super(factory);

   }

   /**
    * Test body
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void testRun() throws Throwable {
      String namespaceURI = "http://www.wedding.com/";
      String qualifiedName;
      Document doc;
      boolean done;
      Element newElement;
      String charact;
      java.util.List illegalQNames = new java.util.ArrayList();
      illegalQNames.add("person:{");
      illegalQNames.add("person:}");
      illegalQNames.add("person:~");
      illegalQNames.add("person:'");
      illegalQNames.add("person:!");
      illegalQNames.add("person:@");
      illegalQNames.add("person:#");
      illegalQNames.add("person:$");
      illegalQNames.add("person:%");
      illegalQNames.add("person:^");
      illegalQNames.add("person:&");
      illegalQNames.add("person:*");
      illegalQNames.add("person:(");
      illegalQNames.add("person:)");
      illegalQNames.add("person:+");
      illegalQNames.add("person:=");
      illegalQNames.add("person:[");
      illegalQNames.add("person:]");
      illegalQNames.add("person:\\");
      illegalQNames.add("person:/");
      illegalQNames.add("person:;");
      illegalQNames.add("person:`");
      illegalQNames.add("person:<");
      illegalQNames.add("person:>");
      illegalQNames.add("person:,");
      illegalQNames.add("person:a ");
      illegalQNames.add("person:\"");
      
      doc = (Document) load("staffNS", false);
      for (int indexd307e125 = 0; indexd307e125 < illegalQNames.size(); indexd307e125++) {
          qualifiedName = ( String) illegalQNames.get(indexd307e125);
    
      {
         boolean success = false;
         try {
            newElement = doc.createElementNS(namespaceURI, qualifiedName);
          } catch (DOMException ex) {
            success = (ex.code == DOMException.INVALID_CHARACTER_ERR);
         }
         assertTrue("throw_INVALID_CHARACTER_ERR", success);
      }
  }
      
   }
   /**
    *  Gets URI that identifies the test
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/createElementNS03";
   }
   /**
    * Runs individual test
    * @param args command line arguments
    */
   public static void main(String[] args) {
        DOMTestCase.doMain(createElementNS03.class, args);
   }
}
