/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.walls;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class Package {
    private String name;
    private String pack;
    private boolean badPackage = false;
    private String failureReason = null;
    private String[] depends;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setPackage(String string) {
        this.pack = string;
    }

    public String getPackage() {
        return this.pack;
    }

    public void setDepends(String string) {
        if (string == null) {
            throw new RuntimeException("depends cannot be set to null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t");
        this.depends = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.depends[n] = stringTokenizer.nextToken();
            ++n;
        }
    }

    public String[] getDepends() {
        return this.depends;
    }

    public FileSet getJavaCopyFileSet(Project project, Location location) throws BuildException {
        if (this.failureReason != null) {
            throw new BuildException(this.failureReason, location);
        }
        if (this.pack.indexOf("/") != -1 || this.pack.indexOf("\\") != -1) {
            throw new BuildException("A package name cannot contain '\\' or '/' like package=" + this.pack + "\nIt must look like biz.xsoftware.* for example", location);
        }
        FileSet fileSet = new FileSet();
        String string = this.getMatch(project, this.pack, ".java");
        fileSet.setIncludes(string);
        return fileSet;
    }

    public FileSet getClassCopyFileSet(Project project, Location location) throws BuildException {
        FileSet fileSet = new FileSet();
        fileSet.setIncludes("**/*.class");
        return fileSet;
    }

    public File getBuildSpace(File file) {
        return new File(file, this.name);
    }

    public Path getSrcPath(File file, Project project) {
        Path path = new Path(project);
        path.setLocation(this.getBuildSpace(file));
        return path;
    }

    public Path getClasspath(File file, Project project) {
        Path path = new Path(project);
        if (this.depends != null) {
            for (int i = 0; i < this.depends.length; ++i) {
                String string = this.depends[i];
                File file2 = new File(file, string);
                path.setLocation(file2);
            }
        }
        return path;
    }

    private String getMatch(Project project, String string, String string2) {
        String string3;
        string = project.replaceProperties(string);
        if ((string = string.replace('.', File.separatorChar)).endsWith("**")) {
            string3 = string + File.separatorChar + "*" + string2;
        } else if (string.endsWith("*")) {
            string3 = string + string2;
        } else {
            throw new RuntimeException("Please report this bug");
        }
        return string3;
    }

    public void setFaultReason(String string) {
        this.failureReason = string;
    }
}

