/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

public class Math {
    private boolean strict = false;

    public Math() {
    }

    public Math(boolean bl) {
        this.strict = bl;
    }

    public void setStrict(boolean bl) {
        this.strict = bl;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public static double add(double d, double d2) {
        return d + d2;
    }

    public static float add(float f, float f2) {
        return f + f2;
    }

    public static long add(long l, long l2) {
        return l + l2;
    }

    public static int add(int n, int n2) {
        return n + n2;
    }

    public static double add(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static float add(float[] fArray) {
        if (fArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fArray.length == 1) {
            return fArray[0];
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            f += fArray[i];
        }
        return f;
    }

    public static long add(long[] lArray) {
        if (lArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (lArray.length == 1) {
            return lArray[0];
        }
        long l = lArray[0];
        for (int i = 1; i < lArray.length; ++i) {
            l += lArray[i];
        }
        return l;
    }

    public static int add(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (nArray.length == 1) {
            return nArray[0];
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public static double subtract(double d, double d2) {
        return d - d2;
    }

    public static float subtract(float f, float f2) {
        return f - f2;
    }

    public static long subtract(long l, long l2) {
        return l - l2;
    }

    public static int subtract(int n, int n2) {
        return n - n2;
    }

    public static double subtract(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d -= dArray[i];
        }
        return d;
    }

    public static float subtract(float[] fArray) {
        if (fArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fArray.length == 1) {
            return fArray[0];
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            f -= fArray[i];
        }
        return f;
    }

    public static long subtract(long[] lArray) {
        if (lArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (lArray.length == 1) {
            return lArray[0];
        }
        long l = lArray[0];
        for (int i = 1; i < lArray.length; ++i) {
            l -= lArray[i];
        }
        return l;
    }

    public static int subtract(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (nArray.length == 1) {
            return nArray[0];
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n -= nArray[i];
        }
        return n;
    }

    public static double multiply(double d, double d2) {
        return d * d2;
    }

    public static float multiply(float f, float f2) {
        return f * f2;
    }

    public static long multiply(long l, long l2) {
        return l * l2;
    }

    public static int multiply(int n, int n2) {
        return n * n2;
    }

    public static double multiply(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d *= dArray[i];
        }
        return d;
    }

    public static float multiply(float[] fArray) {
        if (fArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fArray.length == 1) {
            return fArray[0];
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            f *= fArray[i];
        }
        return f;
    }

    public static long multiply(long[] lArray) {
        if (lArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (lArray.length == 1) {
            return lArray[0];
        }
        long l = lArray[0];
        for (int i = 1; i < lArray.length; ++i) {
            l *= lArray[i];
        }
        return l;
    }

    public static int multiply(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (nArray.length == 1) {
            return nArray[0];
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n *= nArray[i];
        }
        return n;
    }

    public static double divide(double d, double d2) {
        return d / d2;
    }

    public static float divide(float f, float f2) {
        return f / f2;
    }

    public static long divide(long l, long l2) {
        return l / l2;
    }

    public static int divide(int n, int n2) {
        return n / n2;
    }

    public static double divide(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d /= dArray[i];
        }
        return d;
    }

    public static float divide(float[] fArray) {
        if (fArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fArray.length == 1) {
            return fArray[0];
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            f /= fArray[i];
        }
        return f;
    }

    public static long divide(long[] lArray) {
        if (lArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (lArray.length == 1) {
            return lArray[0];
        }
        long l = lArray[0];
        for (int i = 1; i < lArray.length; ++i) {
            l /= lArray[i];
        }
        return l;
    }

    public static int divide(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (nArray.length == 1) {
            return nArray[0];
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n /= nArray[i];
        }
        return n;
    }

    public static double mod(double d, double d2) {
        return d % d2;
    }

    public static float mod(float f, float f2) {
        return f % f2;
    }

    public static long mod(long l, long l2) {
        return l % l2;
    }

    public static int mod(int n, int n2) {
        return n % n2;
    }

    public static double mod(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d %= dArray[i];
        }
        return d;
    }

    public static float mod(float[] fArray) {
        if (fArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fArray.length == 1) {
            return fArray[0];
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            f %= fArray[i];
        }
        return f;
    }

    public static long mod(long[] lArray) {
        if (lArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (lArray.length == 1) {
            return lArray[0];
        }
        long l = lArray[0];
        for (int i = 1; i < lArray.length; ++i) {
            l %= lArray[i];
        }
        return l;
    }

    public static int mod(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (nArray.length == 1) {
            return nArray[0];
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n %= nArray[i];
        }
        return n;
    }

    public Number calculate(String string, String[] stringArray) {
        return this.calculate(string, "double", stringArray);
    }

    public Number calculate(String string, String string2, String[] stringArray) {
        try {
            Class[] classArray;
            String string3;
            int n;
            if (stringArray.length > 2) {
                if (string.equals("add") || string.equals("subtract") || string.equals("multiply") || string.equals("divide") || string.equals("mod")) {
                    return this.calculateArray(string, string2, stringArray);
                }
                throw new IllegalArgumentException("too many operands");
            }
            Class<?> clazz = this.strict ? Class.forName("java.lang.StrictMath") : Class.forName("java.lang.Math");
            if (string.equals("random")) {
                Method method = clazz.getDeclaredMethod(string, new Class[0]);
                Object object = method.invoke(clazz, null);
                return (Number)object;
            }
            Vector<Method> vector = new Vector<Method>();
            Method[] methodArray = clazz.getDeclaredMethods();
            for (n = 0; n < methodArray.length; ++n) {
                string3 = methodArray[n].getName();
                if (!string3.equals(string)) continue;
                vector.addElement(methodArray[n]);
            }
            if (vector.size() == 0) {
                clazz = this.getClass();
                methodArray = clazz.getDeclaredMethods();
                for (n = 0; n < methodArray.length; ++n) {
                    string3 = methodArray[n].getName();
                    if (!string3.equals(string)) continue;
                    vector.addElement(methodArray[n]);
                }
            }
            if (vector.size() == 0) {
                throw new RuntimeException("Unknown operation: " + string);
            }
            Class clazz2 = this.getDataType(string2);
            int n2 = -1;
            try {
                for (int i = 0; i <= vector.size() && (n2 = (classArray = (Method)vector.elementAt(i)).getParameterTypes().length) != stringArray.length; ++i) {
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Wrong number of arguments, have " + stringArray.length + ", but can't find corresponding method.");
            }
            Class clazz3 = null;
            if (vector.size() == 1) {
                classArray = (Method)vector.elementAt(0);
                clazz3 = classArray.getParameterTypes()[0];
            } else {
                classArray = vector.elements();
                while (classArray.hasMoreElements()) {
                    Method method = (Method)classArray.nextElement();
                    if (!method.getParameterTypes()[0].equals(clazz2)) continue;
                    clazz3 = clazz2;
                    break;
                }
                if (clazz3 == null) {
                    throw new RuntimeException("Can't find a method with parameters of type " + string2);
                }
            }
            classArray = new Class[n2];
            for (int i = 0; i < n2; ++i) {
                classArray[i] = clazz3;
            }
            Method method = clazz.getDeclaredMethod(string, classArray);
            Object[] objectArray = this.getParams(clazz3, stringArray);
            Object object = method.invoke(clazz, objectArray);
            return (Number)object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private Number calculateArray(String string, String string2, String[] stringArray) {
        try {
            Object object;
            Class<?> clazz = this.getClass();
            Vector<Method> vector = new Vector<Method>();
            Method[] methodArray = clazz.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                object = methodArray[i].getName();
                if (!((String)object).equals(string) || methodArray[i].getParameterTypes().length != 1 || !methodArray[i].getParameterTypes()[0].isArray()) continue;
                vector.addElement(methodArray[i]);
            }
            if (vector.size() == 0) {
                throw new RuntimeException("Unknown operation: " + string);
            }
            Object object2 = this.getDataTypeArray(string2, stringArray.length);
            object = null;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Method method = (Method)enumeration.nextElement();
                if (!method.getParameterTypes()[0].equals(object2.getClass())) continue;
                object = this.getDataType(string2);
                Object[] objectArray = this.getParamsArray((Class)object, stringArray);
                Object object3 = method.invoke(clazz, objectArray);
                return (Number)object3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private Class getDataType(String string) {
        if (string == null) {
            return Double.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        return Double.TYPE;
    }

    private Object getDataTypeArray(String string, int n) {
        if (string == null) {
            return Array.newInstance(Double.TYPE, n);
        }
        if (string.equals("int")) {
            return Array.newInstance(Integer.TYPE, n);
        }
        if (string.equals("long")) {
            return Array.newInstance(Long.TYPE, n);
        }
        if (string.equals("float")) {
            return Array.newInstance(Float.TYPE, n);
        }
        return Array.newInstance(Double.TYPE, n);
    }

    private Object[] getParams(Class clazz, String[] stringArray) {
        int n = stringArray.length;
        Object[] objectArray = new Object[n];
        if (clazz == Double.TYPE) {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new Double(stringArray[i]);
            }
        } else if (clazz == Long.TYPE) {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new Long(stringArray[i]);
            }
        } else if (clazz == Float.TYPE) {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new Float(stringArray[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new Integer(stringArray[i]);
            }
        }
        if (n > 2) {
            objectArray = new Object[]{objectArray};
        }
        return objectArray;
    }

    private Object[] getParamsArray(Class clazz, String[] stringArray) {
        int n = stringArray.length;
        if (clazz == Double.TYPE) {
            double[] dArray = (double[])Array.newInstance(clazz, stringArray.length);
            for (int i = 0; i < n; ++i) {
                Array.setDouble(dArray, i, new Double(stringArray[i]));
            }
            return new Object[]{dArray};
        }
        if (clazz == Long.TYPE) {
            long[] lArray = (long[])Array.newInstance(clazz, stringArray.length);
            for (int i = 0; i < n; ++i) {
                Array.setLong(lArray, i, new Long(stringArray[i]));
            }
            return new Object[]{lArray};
        }
        if (clazz == Float.TYPE) {
            float[] fArray = (float[])Array.newInstance(clazz, stringArray.length);
            for (int i = 0; i < n; ++i) {
                Array.setFloat(fArray, i, new Float(stringArray[i]).floatValue());
            }
            return new Object[]{fArray};
        }
        Object object = Array.newInstance(clazz, stringArray.length);
        for (int i = 0; i < n; ++i) {
            Array.setInt(object, i, new Integer(stringArray[i]));
        }
        return new Object[]{object};
    }

    public static void main(String[] stringArray) {
        Math math = new Math();
        System.out.println(math.calculate("add", new String[]{"6", "5", "4"}));
    }
}

