
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.w3c.dom.*;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
* 

    The "setAttributeNodeNS(newAttr)" method raises an 

   "WRONG_DOCUMENT_ERR DOMException if the "newAttr" 

   was created from a different document than the one that

   created this document.

   

   Retrieve the first emp:address and attempt to set a new

   attribute node.  The new

   attribute was created from a document other than the

   one that created this element, therefore a

   WRONG_DOCUMENT_ERR DOMException should be raised.

   This test uses the "createAttributeNS(newAttr)" method

   from the Document interface.


*
 *@freq weekly
*
 *@freq weekly
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-258A00AF')/constant[@name='WRONG_DOCUMENT_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-258A00AF')/constant[@name='WRONG_DOCUMENT_ERR'])</a>
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS</a>
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-ElSetAtNodeNS')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='WRONG_DOCUMENT_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-ElSetAtNodeNS')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='WRONG_DOCUMENT_ERR'])</a>
*/
public class setAttributeNodeNS05 extends DOMTestCase {public setAttributeNodeNS05(String name){super(name);	}public static Test suite() {	return new TestSuite(setAttributeNodeNS05.class);	}

   /**
    * Constructor
    * @param factory document factory, may not be null
    */
   public setAttributeNodeNS05(DOMTestDocumentBuilderFactory factory)  {
      super(factory);

   }

   /**
    * Test body
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void testRun() throws Throwable {
      String namespaceURI = "http://www.newattr.com";
      String qualifiedName = "emp:newAttr";
      Document doc1;
      Document doc2;
      Attr newAttr;
      NodeList elementList;
      Node testAddr;
      Attr setAttr1;
      doc1 = (Document) load("staffNS", true);
      doc2 = (Document) load("staffNS", true);
      newAttr = doc2.createAttributeNS(namespaceURI, qualifiedName);
      elementList = doc1.getElementsByTagName("emp:address");
      testAddr = elementList.item(0);
      
      {
         boolean success = false;
         try {
            setAttr1 = ((Element) /*Node */testAddr).setAttributeNodeNS(newAttr);
          } catch (DOMException ex) {
            success = (ex.code == DOMException.WRONG_DOCUMENT_ERR);
         }
         assertTrue("throw_WRONG_DOCUMENT_ERR", success);
      }

   }
   /**
    *  Gets URI that identifies the test
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/setAttributeNodeNS05";
   }
   /**
    * Runs individual test
    * @param args command line arguments
    */
   public static void main(String[] args) {
        DOMTestCase.doMain(setAttributeNodeNS05.class, args);
   }
}
