
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
* 
    The "importNode(importedNode,deep)" method for a 
   Document should import the given importedNode into that Document.
   The importedNode is of type Entity.
   
   Retrieve entity "ent6" from staffNS.xml document.  
   Invoke method importNode(importedNode,deep) on this document.
   Method should return a node of type Entity whose publicId, systemId and
   notationName attributes are copied.
   The returned node should belong to this document whose systemId is "staff.dtd"

* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode">http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode</a>
*/

/**
*
 *@ignore true
 */
public class importNode09 extends DOMTestCase {public importNode09(String name){super(name);	}public static Test suite() {	return new TestSuite(importNode09.class);	}

   /**
    * Constructor
    * @param factory document factory, may not be null
    */
   public importNode09(DOMTestDocumentBuilderFactory factory)  {
      super(factory);

   }

   /**
    * Test body
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void testRun() throws Throwable {
      Document doc;
      Document aNewDoc;
      DocumentType doc1Type;
      NamedNodeMap entityList;
      Entity entity2;
      Entity entity1;
      Document ownerDocument;
      DocumentType docType;
      String system;
      String entityName;
      String publicVal;
      String notationName;
      doc = (Document) load("staffNS", true);
      aNewDoc = (Document) load("staffNS", true);
      docType = aNewDoc.getDoctype();
      entityList = docType.getEntities();
      entity2 = (Entity) entityList.getNamedItem("ent6");
      entity1 = (Entity) doc.importNode(entity2, false);
      ownerDocument = entity1.getOwnerDocument();
      docType = ownerDocument.getDoctype();
      system = docType.getSystemId();
      assertURIEquals("dtdSystemId", null, null, null, "staffNS.dtd", null, null, null, null, system);
entityName = entity1.getNodeName();
      assertEquals("entityName", "ent6", entityName);
      publicVal = entity1.getPublicId();
      assertEquals("entityPublicId", "uri", publicVal);
      system = entity1.getSystemId();
      assertURIEquals("entitySystemId", null, null, null, "file", null, null, null, null, system);
notationName = entity1.getNotationName();
      assertEquals("notationName", "notation2", notationName);
      
   }
   /**
    *  Gets URI that identifies the test
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/importNode09";
   }
   /**
    * Runs individual test
    * @param args command line arguments
    */
   public static void main(String[] args) {
        DOMTestCase.doMain(importNode09.class, args);
   }
}
