
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2003 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NodeList;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
* 
    The method getElementsByTagNameNS returns a NodeList of all the Elements with 
    a given local name and namespace URI in the order in which they are encountered 
    in a preorder traversal of the Document tree.
    
    Invoke the getElementsByTagNameNS method on a new Document object with the values of
    namespaceURI=* and localName=*.  This should return a nodeList of 1 item.

*
 *@freq weekly
*
 *@freq weekly
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core">http://www.w3.org/TR/DOM-Level-2-Core/core</a>
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-getElBTNNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-getElBTNNS</a>
* @see <a href="http://www.w3.org/Bugs/Public/show_bug.cgi?id=259">http://www.w3.org/Bugs/Public/show_bug.cgi?id=259</a>
*/
public class documentgetelementsbytagnameNS01 extends DOMTestCase {public documentgetelementsbytagnameNS01(String name){super(name);	}public static Test suite() {	return new TestSuite(documentgetelementsbytagnameNS01.class);	}

   /**
    * Constructor
    * @param factory document factory, may not be null
    */
   public documentgetelementsbytagnameNS01(DOMTestDocumentBuilderFactory factory)  {
      super(factory);

   }

   /**
    * Test body
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void testRun() throws Throwable {
      Document doc;
      Document newDoc;
      DocumentType docType = null;

      DOMImplementation domImpl;
      NodeList childList;
      String nullNS = null;

      doc = (Document) load("staffNS", false);
      domImpl = doc.getImplementation();
      newDoc = domImpl.createDocument(nullNS, "root", docType);
      childList = newDoc.getElementsByTagNameNS("*", "*");
      assertSize("documentgetelementsbytagnameNS01", 1, childList);
      
   }
   /**
    *  Gets URI that identifies the test
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/documentgetelementsbytagnameNS01";
   }
   /**
    * Runs individual test
    * @param args command line arguments
    */
   public static void main(String[] args) {
        DOMTestCase.doMain(documentgetelementsbytagnameNS01.class, args);
   }
}
