/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.antserver.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import net.sf.antcontrib.antserver.server.ConnectionHandler;
import net.sf.antcontrib.antserver.server.ServerTask;
import org.apache.tools.ant.BuildException;

public class Server
implements Runnable {
    private ServerTask task;
    private int port = 17000;
    private boolean running = false;
    private Thread thread = null;

    public Server(ServerTask serverTask, int n) {
        this.task = serverTask;
        this.port = n;
    }

    public void start() throws InterruptedException {
        this.thread = new Thread(this);
        this.thread.start();
        this.thread.join();
    }

    public void stop() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ServerSocket serverSocket = null;
        this.running = true;
        try {
            this.task.getProject().log("Starting server on port: " + this.port, 4);
            try {
                serverSocket = new ServerSocket(this.port);
                serverSocket.setSoTimeout(500);
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
            while (this.running) {
                try {
                    Socket socket = serverSocket.accept();
                    this.task.getProject().log("Got a client connection. Starting Handler.", 4);
                    ConnectionHandler connectionHandler = new ConnectionHandler(this.task, socket);
                    connectionHandler.start();
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (IOException iOException) {
                    this.task.getProject().log(iOException.getMessage(), 0);
                }
            }
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                    serverSocket = null;
                }
                catch (IOException iOException) {}
            }
        }
        this.running = false;
    }
}

