
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.w3c.dom.*;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
* 
    The method setAttributeNodeNS Adds a new attribute and raises an WRONG_DOCUMENT_ERR if this node 
    is readonly.

    Attempt to add an attribute node to an element node which is part of the replacement text of 
    a read-only EntityReference node.
    Check if a NO_MODIFICATION_ALLOWED_ERR is thrown.

* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS</a>
*/


/**
 *
 * @ignore true: ER
 */

public class elementsetattributenodens06 extends DOMTestCase {public elementsetattributenodens06(String name){super(name);	}public static Test suite() {	return new TestSuite(elementsetattributenodens06.class);	}

   /**
    * Constructor
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public elementsetattributenodens06(DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.notExpandEntityReferences
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

   }

   /**
    * Test body
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void testRun() throws Throwable {
      Document doc;
      Element element;
      Attr attribute;
      Attr attribute2;
      EntityReference entRef;
      NodeList elementList;
      Node newAttribute;
      Node newChild;
      doc = (Document) load("staffNS", true);
      element = doc.createElementNS("http://www.w3.org/DOM/Test", "elem1");
      attribute = doc.createAttributeNS("http://www.w3.org/DOM/Test", "attr");
      entRef = doc.createEntityReference("ent4");
      newChild = attribute.appendChild(entRef);
      newAttribute = element.setAttributeNodeNS(attribute);
      elementList = entRef.getChildNodes();
      element = (Element) elementList.item(0);
      attribute2 = doc.createAttributeNS("http://www.w3.org/DOM/Test", "attr2");
      
      {
         boolean success = false;
         try {
            newAttribute = element.setAttributeNodeNS(attribute2);
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
         }
         assertTrue("elementsetattributenodens06", success);
      }

   }
   /**
    *  Gets URI that identifies the test
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/elementsetattributenodens06";
   }
   /**
    * Runs individual test
    * @param args command line arguments
    */
   public static void main(String[] args) {
        DOMTestCase.doMain(elementsetattributenodens06.class, args);
   }
}
