
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.w3c.dom.Document;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
* 
    The importNode method imports a node from another document to this document. 
    The returned node has no parent; (parentNode is null). The source node is not 
    altered or removed from the original document but a new copy of the source node
    is created.
    
    Using the method importNode with deep=true, import a newly created PI node for this
    Document.  Verify if the node has been imported correctly by checking the PITarget and 
    PIData values of the imported PI node.

*
 *@freq weekly
*
 *@freq weekly
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core">http://www.w3.org/TR/DOM-Level-2-Core/core</a>
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode">http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode</a>
*/
public class documentimportnode18 extends DOMTestCase {public documentimportnode18(String name){super(name);	}public static Test suite() {	return new TestSuite(documentimportnode18.class);	}

   /**
    * Constructor
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public documentimportnode18(DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

   }

   /**
    * Test body
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void testRun() throws Throwable {
      Document doc;
      Document docImp;
      ProcessingInstruction piImport;
      ProcessingInstruction piToImport;
      String PIData;
      String PITarget;
      doc = (Document) load("staffNS", true);
      docImp = (Document) load("staffNS", true);
      piToImport = doc.createProcessingInstruction("Target", "Data");
      piImport = (ProcessingInstruction) doc.importNode(piToImport, false);
      PITarget = piImport.getTarget();
      PIData = piImport.getData();
      assertEquals("documentimportnode18_Target", "Target", PITarget);
      assertEquals("documentimportnode18_Data", "Data", PIData);
      
   }
   /**
    *  Gets URI that identifies the test
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/documentimportnode18";
   }
   /**
    * Runs individual test
    * @param args command line arguments
    */
   public static void main(String[] args) {
        DOMTestCase.doMain(documentimportnode18.class, args);
   }
}
