/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class TimestampSelector
extends Task {
    private static final String AGE_ELDEST = "eldest";
    private static final String AGE_YOUNGEST = "youngest";
    private String property;
    private Path path;
    private String outputSetId;
    private int count = 1;
    private char pathSep = (char)44;
    private String age = "youngest";

    public void doFileSetExecute(String[] stringArray) throws BuildException {
    }

    public void sort(Vector vector) {
        this.sort(vector, 0, vector.size() - 1);
    }

    protected void sort(Vector vector, int n, int n2) {
        if (n2 > n) {
            int n3 = this.partition(vector, n, n2);
            this.sort(vector, n, n3 - 1);
            this.sort(vector, n3 + 1, n2);
        }
    }

    protected int compare(File file, File file2) {
        if (this.age.equalsIgnoreCase(AGE_ELDEST)) {
            return new Long(file.lastModified()).compareTo(new Long(file2.lastModified()));
        }
        return new Long(file2.lastModified()).compareTo(new Long(file.lastModified()));
    }

    protected int partition(Vector vector, int n, int n2) {
        File file = (File)vector.elementAt(n2);
        int n3 = n - 1;
        int n4 = n2;
        while (true) {
            if (this.compare(file, (File)vector.elementAt(++n3)) == 1 && n3 != n2) {
                continue;
            }
            while (this.compare(file, (File)vector.elementAt(--n4)) == -1 && n4 != n) {
            }
            if (n3 >= n4) break;
            this.swap(vector, n3, n4);
        }
        this.swap(vector, n3, n2);
        return n3;
    }

    protected void swap(Vector vector, int n, int n2) {
        Object e = vector.elementAt(n);
        vector.setElementAt(vector.elementAt(n2), n);
        vector.setElementAt(e, n2);
    }

    public void execute() throws BuildException {
        Comparable<File> comparable;
        if (this.property == null && this.outputSetId == null) {
            throw new BuildException("Property or OutputSetId must be specified.");
        }
        if (this.path == null) {
            throw new BuildException("A path element or pathref attribute must be specified.");
        }
        String[] stringArray = this.path.list();
        Vector<File> vector = new Vector<File>();
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            if (!file.exists()) continue;
            vector.addElement(file);
        }
        this.sort(vector);
        Vector vector2 = new Vector();
        int n = vector.size();
        for (int i = 0; i < n && i < this.count; ++i) {
            vector2.add(vector.elementAt(i));
        }
        Path path = new Path(this.getProject());
        n = vector2.size();
        for (int i = 0; i < n; ++i) {
            comparable = (File)vector.elementAt(i);
            Path path2 = new Path(this.getProject(), ((File)comparable).getAbsolutePath());
            path.addExisting(path2);
        }
        if (this.outputSetId != null) {
            this.project.addReference(this.outputSetId, (Object)path);
        } else {
            String[] stringArray2 = path.list();
            comparable = new StringBuffer();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (i != 0) {
                    ((StringBuffer)comparable).append(this.pathSep);
                }
                ((StringBuffer)comparable).append(stringArray2[i]);
            }
            if (stringArray2.length != 0) {
                this.project.setProperty(this.property, ((StringBuffer)comparable).toString());
            }
        }
    }

    public void setProperty(String string) {
        if (this.outputSetId != null) {
            throw new BuildException("Cannot set both Property and OutputSetId.");
        }
        this.property = string;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public void setAge(String string) {
        if (!string.equalsIgnoreCase(AGE_ELDEST) && !string.equalsIgnoreCase(AGE_YOUNGEST)) {
            throw new BuildException("Invalid age: " + string);
        }
        this.age = string;
    }

    public void setPathSep(char c) {
        this.pathSep = c;
    }

    public void setOutputSetId(String string) {
        if (this.property != null) {
            throw new BuildException("Cannot set both Property and OutputSetId.");
        }
        this.outputSetId = string;
    }

    public void setPathRef(Reference reference) throws BuildException {
        if (this.path != null) {
            throw new BuildException("Path element already specified.");
        }
        this.path = new Path(this.getProject());
        this.path.setRefid(reference);
    }

    public Path createPath() throws BuildException {
        if (this.path != null) {
            throw new BuildException("Path element already specified.");
        }
        this.path = new Path(this.getProject());
        return this.path;
    }
}

