/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Sequential;

public class TryCatchTask
extends Task {
    private Sequential tryTasks = null;
    private Sequential catchTasks = null;
    private Sequential finallyTasks = null;
    private String property = null;
    private String reference = null;

    public void addTry(Sequential sequential) throws BuildException {
        if (this.tryTasks != null) {
            throw new BuildException("You must not specify more than one <try>");
        }
        this.tryTasks = sequential;
    }

    public void addCatch(Sequential sequential) throws BuildException {
        if (this.catchTasks != null) {
            throw new BuildException("You must not specify more than one <catch>");
        }
        this.catchTasks = sequential;
    }

    public void addFinally(Sequential sequential) throws BuildException {
        if (this.finallyTasks != null) {
            throw new BuildException("You must not specify more than one <finally>");
        }
        this.finallyTasks = sequential;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setReference(String string) {
        this.reference = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.tryTasks == null) {
            throw new BuildException("A nested <try> element is required");
        }
        try {
            this.tryTasks.perform();
        }
        catch (BuildException buildException) {
            if (this.property != null) {
                this.project.setProperty(this.property, buildException.getMessage());
            }
            if (this.reference != null) {
                this.project.addReference(this.reference, (Object)buildException);
            }
            if (this.catchTasks == null) {
                throw buildException;
            }
            this.log("Caught exception: " + buildException.getMessage(), 2);
            this.catchTasks.perform();
        }
        finally {
            if (this.finallyTasks != null) {
                this.finallyTasks.perform();
            }
        }
    }
}

