/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;

public class Variable
extends Task {
    private String value = "";
    private String name = null;
    private File file = null;

    public void setName(String string) {
        this.name = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void execute() throws BuildException {
        if (this.file == null) {
            if (this.name == null || this.name.equals("")) {
                throw new BuildException("The 'name' attribute is required.");
            }
            if (this.value == null) {
                this.value = "";
            }
            this.value = this.getProject().replaceProperties(this.value);
            this.forceProperty(this.name, this.value);
        } else {
            if (!this.file.exists()) {
                throw new BuildException(this.file.getAbsolutePath() + " does not exists.");
            }
            this.loadFile(this.file);
        }
    }

    private void forceProperty(String string, String string2) {
        try {
            Hashtable hashtable = (Hashtable)this.getValue(this.getProject(), "properties");
            if (hashtable == null) {
                this.getProject().setUserProperty(string, string2);
            } else {
                hashtable.put(string, string2);
            }
        }
        catch (Exception exception) {
            this.getProject().setUserProperty(string, string2);
        }
    }

    private Field getField(Class clazz, String string) throws NoSuchFieldException {
        if (clazz == null) {
            throw new NoSuchFieldException("Invalid field : " + string);
        }
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return this.getField(clazz.getSuperclass(), string);
        }
    }

    private Object getValue(Object object, String string) throws IllegalAccessException, NoSuchFieldException {
        Field field = this.getField(object.getClass(), string);
        field.setAccessible(true);
        return field.get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(File file) throws BuildException {
        block8: {
            Properties properties = new Properties();
            try {
                if (file.exists()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        properties.load(fileInputStream);
                    }
                    finally {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    this.addProperties(properties);
                    break block8;
                }
                this.log("Unable to find property file: " + file.getAbsolutePath(), 3);
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException, this.location);
            }
        }
    }

    protected void addProperties(Properties properties) {
        this.resolveAllProperties(properties);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.forceProperty(string, string2);
        }
    }

    private void resolveAllProperties(Properties properties) throws BuildException {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            boolean bl = false;
            while (!bl) {
                Vector vector = new Vector();
                Vector vector2 = new Vector();
                ProjectHelper.parsePropertyString((String)string2, vector, vector2);
                bl = true;
                if (vector2.size() == 0) continue;
                StringBuffer stringBuffer = new StringBuffer();
                Enumeration enumeration2 = vector.elements();
                Enumeration enumeration3 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    String string3 = (String)enumeration2.nextElement();
                    if (string3 == null) {
                        String string4 = (String)enumeration3.nextElement();
                        if (string4.equals(string)) {
                            throw new BuildException("Property " + string + " was circularly " + "defined.");
                        }
                        string3 = this.getProject().getProperty(string4);
                        if (string3 == null) {
                            if (properties.containsKey(string4)) {
                                string3 = properties.getProperty(string4);
                                bl = false;
                            } else {
                                string3 = "${" + string4 + "}";
                            }
                        }
                    }
                    stringBuffer.append(string3);
                }
                string2 = stringBuffer.toString();
                properties.put(string, string2);
            }
        }
    }
}

