/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.CallTarget;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class ForEach
extends Task {
    private String list = null;
    private String param = null;
    private String delimiter = ",";
    private String target = null;
    private boolean inheritAll = false;
    private boolean inheritRefs = false;
    private Vector params = new Vector();
    private Vector references = new Vector();
    private Path currPath;
    private boolean parallel = false;
    private boolean trim;
    private int maxThreads = 5;

    private void executeParallelNew(Vector vector) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        TaskContainer taskContainer = (TaskContainer)this.getProject().createTask("parallel");
        Class[] classArray = new Class[]{Integer.TYPE};
        Object[] objectArray = new Object[]{new Integer(this.maxThreads)};
        Method method = taskContainer.getClass().getMethod("setThreadsPerProcessor", classArray);
        method.invoke((Object)taskContainer, objectArray);
        Enumeration enumeration = vector.elements();
        Task task = null;
        while (enumeration.hasMoreElements()) {
            task = (Task)enumeration.nextElement();
            taskContainer.addTask(task);
        }
        ((Task)taskContainer).execute();
    }

    private void executeParallelOld(Vector vector) {
        TaskContainer taskContainer = (TaskContainer)this.getProject().createTask("parallel");
        Enumeration enumeration = vector.elements();
        Task task = null;
        int n = 0;
        while (enumeration.hasMoreElements()) {
            task = (Task)enumeration.nextElement();
            taskContainer.addTask(task);
            if (++n < this.maxThreads) continue;
            ((Task)taskContainer).execute();
            taskContainer = (TaskContainer)this.getProject().createTask("parallel");
            n = 0;
        }
        if (n > 0) {
            ((Task)taskContainer).execute();
        }
    }

    private void executeParallel(Vector vector) {
        boolean bl = false;
        try {
            this.executeParallelNew(vector);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = true;
        }
        catch (IllegalAccessException illegalAccessException) {
            bl = true;
        }
        catch (InvocationTargetException invocationTargetException) {
            bl = true;
        }
        if (bl) {
            this.executeParallelOld(vector);
        }
    }

    private void executeSequential(Vector vector) {
        TaskContainer taskContainer = (TaskContainer)this.getProject().createTask("sequential");
        Enumeration enumeration = vector.elements();
        Task task = null;
        while (enumeration.hasMoreElements()) {
            task = (Task)enumeration.nextElement();
            taskContainer.addTask(task);
        }
        ((Task)taskContainer).execute();
    }

    public void execute() throws BuildException {
        Object object;
        if (this.list == null && this.currPath == null) {
            throw new BuildException("You must have a list or path to iterate through");
        }
        if (this.param == null) {
            throw new BuildException("You must supply a property name to set on each iteration in param");
        }
        if (this.target == null) {
            throw new BuildException("You must supply a target to perform");
        }
        Vector<Object> vector = new Vector<Object>();
        if (this.list != null) {
            object = new StringTokenizer(this.list, this.delimiter);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                if (this.trim) {
                    string = string.trim();
                }
                vector.addElement(string);
            }
        }
        object = new String[]{};
        if (this.currPath != null) {
            object = this.currPath.list();
        }
        for (int i = 0; i < ((Object)object).length; ++i) {
            vector.addElement(new File((String)object[i]));
        }
        Vector<CallTarget> vector2 = new Vector<CallTarget>();
        int n = vector.size();
        CallTarget callTarget = null;
        Object var6_8 = null;
        Property property = null;
        for (int i = 0; i < n; ++i) {
            var6_8 = vector.elementAt(i);
            callTarget = this.createCallTarget();
            property = callTarget.createParam();
            property.setName(this.param);
            if (var6_8 instanceof File) {
                property.setLocation((File)var6_8);
            } else {
                property.setValue((String)var6_8);
            }
            vector2.addElement(callTarget);
        }
        if (this.parallel && this.maxThreads > 1) {
            this.executeParallel(vector2);
        } else {
            this.executeSequential(vector2);
        }
    }

    public void setTrim(boolean bl) {
        this.trim = bl;
    }

    public void setList(String string) {
        this.list = string;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public void setParam(String string) {
        this.param = string;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setParallel(boolean bl) {
        this.parallel = bl;
    }

    public void setInheritall(boolean bl) {
        this.inheritAll = bl;
    }

    public void setInheritrefs(boolean bl) {
        this.inheritRefs = bl;
    }

    public void setMaxThreads(int n) {
        this.maxThreads = n;
    }

    public void addParam(Property property) {
        this.params.addElement(property);
    }

    public void addReference(Ant.Reference reference) {
        this.references.addElement(reference);
    }

    public void addFileset(FileSet fileSet) {
        this.log("The nested fileset element is deprectated, use a nested path instead", 1);
        this.createPath().addFileset(fileSet);
    }

    public Path createPath() {
        if (this.currPath == null) {
            this.currPath = new Path(this.getProject());
        }
        return this.currPath;
    }

    private CallTarget createCallTarget() {
        CallTarget callTarget = (CallTarget)this.getProject().createTask("antcall");
        callTarget.setOwningTarget(this.getOwningTarget());
        callTarget.init();
        callTarget.setTarget(this.target);
        callTarget.setInheritAll(this.inheritAll);
        callTarget.setInheritRefs(this.inheritRefs);
        Enumeration enumeration = this.params.elements();
        while (enumeration.hasMoreElements()) {
            Property property = (Property)enumeration.nextElement();
            Property property2 = callTarget.createParam();
            property2.setName(property.getName());
            if (property.getValue() != null) {
                property2.setValue(property.getValue());
            }
            if (property.getFile() != null) {
                property2.setFile(property.getFile());
            }
            if (property.getResource() != null) {
                property2.setResource(property.getResource());
            }
            if (property.getPrefix() != null) {
                property2.setPrefix(property.getPrefix());
            }
            if (property.getRefid() != null) {
                property2.setRefid(property.getRefid());
            }
            if (property.getEnvironment() != null) {
                property2.setEnvironment(property.getEnvironment());
            }
            if (property.getClasspath() == null) continue;
            property2.setClasspath(property.getClasspath());
        }
        enumeration = this.references.elements();
        while (enumeration.hasMoreElements()) {
            callTarget.addReference((Ant.Reference)enumeration.nextElement());
        }
        return callTarget;
    }

    protected void handleOutput(String string) {
        try {
            super.handleOutput(string);
        }
        catch (IllegalAccessError illegalAccessError) {
            super.handleOutput(string);
        }
    }

    protected void handleErrorOutput(String string) {
        try {
            super.handleErrorOutput(string);
        }
        catch (IllegalAccessError illegalAccessError) {
            super.handleErrorOutput(string);
        }
    }
}

