/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.antserver.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.antcontrib.antserver.Command;
import net.sf.antcontrib.antserver.Response;
import net.sf.antcontrib.antserver.client.Client;
import net.sf.antcontrib.antserver.commands.RunAntCommand;
import net.sf.antcontrib.antserver.commands.RunTargetCommand;
import net.sf.antcontrib.antserver.commands.SendFileCommand;
import net.sf.antcontrib.antserver.commands.ShutdownCommand;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ClientTask
extends Task {
    private String machine = "localhost";
    private int port = 17000;
    private Vector commands = new Vector();
    private boolean persistant = false;
    private boolean failOnError = true;

    public void setMachine(String string) {
        this.machine = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setPersistant(boolean bl) {
        this.persistant = bl;
    }

    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    public void addConfiguredShutdown(ShutdownCommand shutdownCommand) {
        this.commands.add(shutdownCommand);
    }

    public void addConfiguredRunTarget(RunTargetCommand runTargetCommand) {
        this.commands.add(runTargetCommand);
    }

    public void addConfiguredRunAnt(RunAntCommand runAntCommand) {
        this.commands.add(runAntCommand);
    }

    public void addConfiguredSendFile(SendFileCommand sendFileCommand) {
        this.commands.add(sendFileCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Enumeration enumeration = this.commands.elements();
        Command command = null;
        while (enumeration.hasMoreElements()) {
            command = (Command)enumeration.nextElement();
            command.validate();
        }
        Client client = new Client(this.getProject(), this.machine, this.port);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            try {
                int n = 0;
                client.connect();
                enumeration = this.commands.elements();
                command = null;
                Response response = null;
                Document document = null;
                boolean bl = true;
                while (enumeration.hasMoreElements() && bl) {
                    command = (Command)enumeration.nextElement();
                    response = client.sendCommand(command);
                    if (!response.isSucceeded()) {
                        ++n;
                        this.log("Command caused a build failure:" + command, 0);
                        if (!this.persistant) {
                            bl = false;
                        }
                    }
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(response.getResultsXml().getBytes());
                        document = documentBuilder.parse(byteArrayInputStream);
                        NodeList nodeList = document.getElementsByTagName("target");
                        int n2 = nodeList.getLength();
                        Element element = null;
                        for (int i = 0; i < n2; ++i) {
                            element = (Element)nodeList.item(i);
                            this.getProject().log("[" + element.getAttribute("name") + "]", 2);
                        }
                    }
                    catch (SAXException sAXException) {
                    }
                }
                if (n > 0 && this.failOnError) {
                    throw new BuildException("One or more commands failed.");
                }
            }
            finally {
                if (client != null) {
                    client.disconnect();
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new BuildException((Throwable)parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }
}

