
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.w3c.dom.*;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
* 

    The "setNamedItemNS(arg)" method for a 

   NamedNodeMap should raise WRONG_DOCUMENT_ERR DOMException if arg was

   created from a different document than the one that created this map.

   

   Create an attr node in a different document with qualifiedName equals

   "dmstc:domestic" and namespaceURI is "http://www.usa.com".

   Access the namednodemap of the first "address" element in this document.

   Invoke method setNamedItemNS(arg) with arg being the attr node from above.

   Method should raise WRONG_DOCUMENT_ERR DOMException.


*
 *@freq weekly
*
 *@freq weekly
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-258A00AF')/constant[@name='WRONG_DOCUMENT_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-258A00AF')/constant[@name='WRONG_DOCUMENT_ERR'])</a>
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-setNamedItemNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-setNamedItemNS</a>
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-setNamedItemNS')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='WRONG_DOCUMENT_ERR'])">http://www.w3.org/TR/DOM-Level-2-Core/core#xpointer(id('ID-setNamedItemNS')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='WRONG_DOCUMENT_ERR'])</a>
*/
public class setNamedItemNS02 extends DOMTestCase {public setNamedItemNS02(String name){super(name);	}public static Test suite() {	return new TestSuite(setNamedItemNS02.class);	}

   /**
    * Constructor
    * @param factory document factory, may not be null
    */
   public setNamedItemNS02(DOMTestDocumentBuilderFactory factory)  {
      super(factory);

   }

   /**
    * Test body
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void testRun() throws Throwable {
      String namespaceURI = "http://www.usa.com";
      String qualifiedName = "dmstc:domestic";
      Document doc;
      Document anotherDoc;
      Node arg;
      NodeList elementList;
      Node testAddress;
      NamedNodeMap attributes;
      Node setNode;
      doc = (Document) load("staffNS", true);
      anotherDoc = (Document) load("staffNS", true);
      arg = anotherDoc.createAttributeNS(namespaceURI, qualifiedName);
      arg.setNodeValue("Maybe");
      elementList = doc.getElementsByTagName("address");
      testAddress = elementList.item(0);
      attributes = testAddress.getAttributes();
      
      {
         boolean success = false;
         try {
            setNode = attributes.setNamedItemNS(arg);
          } catch (DOMException ex) {
            success = (ex.code == DOMException.WRONG_DOCUMENT_ERR);
         }
         assertTrue("throw_WRONG_DOCUMENT_ERR", success);
      }

   }
   /**
    *  Gets URI that identifies the test
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/setNamedItemNS02";
   }
   /**
    * Runs individual test
    * @param args command line arguments
    */
   public static void main(String[] args) {
        DOMTestCase.doMain(setNamedItemNS02.class, args);
   }
}
