/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.reflectionmodel;

import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.resolution.declarations.ResolvedAnnotationMemberDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ReflectionAnnotationMemberDeclaration
implements ResolvedAnnotationMemberDeclaration {
    private static Map<Class<?>, Function<Object, ? extends Expression>> valueAsExressionConverter = new HashMap();
    private Method annotationMember;
    private TypeSolver typeSolver;

    public ReflectionAnnotationMemberDeclaration(Method annotationMember, TypeSolver typeSolver) {
        this.annotationMember = annotationMember;
        this.typeSolver = typeSolver;
    }

    public Expression getDefaultValue() {
        Object value = this.annotationMember.getDefaultValue();
        Function<Object, ? extends Expression> fn = valueAsExressionConverter.get(value.getClass());
        if (fn == null) {
            throw new UnsupportedOperationException(String.format("Obtaining the type of the annotation member %s is not supported yet.", this.annotationMember.getName()));
        }
        return fn.apply(value);
    }

    public ResolvedType getType() {
        Class<?> returnType = this.annotationMember.getReturnType();
        if (returnType.isPrimitive()) {
            return ResolvedPrimitiveType.byName((String)returnType.getName());
        }
        SymbolReference<ResolvedReferenceTypeDeclaration> rrtd = this.typeSolver.tryToSolveType(returnType.getName());
        if (rrtd.isSolved()) {
            return new ReferenceTypeImpl(rrtd.getCorrespondingDeclaration(), this.typeSolver);
        }
        throw new UnsupportedOperationException(String.format("Obtaining the type of the annotation member %s is not supported yet.", this.annotationMember.getName()));
    }

    public String getName() {
        return this.annotationMember.getName();
    }

    static {
        valueAsExressionConverter.put(Boolean.class, value -> new BooleanLiteralExpr(((Boolean)Boolean.class.cast(value)).booleanValue()));
        valueAsExressionConverter.put(Character.class, value -> new CharLiteralExpr(((Character)Character.class.cast(value)).charValue()));
        valueAsExressionConverter.put(Double.class, value -> new DoubleLiteralExpr(((Double)Double.class.cast(value)).doubleValue()));
        valueAsExressionConverter.put(Integer.class, value -> new IntegerLiteralExpr(((Integer)Integer.class.cast(value)).intValue()));
        valueAsExressionConverter.put(Long.class, value -> new LongLiteralExpr(((Long)Long.class.cast(value)).longValue()));
        valueAsExressionConverter.put(String.class, value -> new StringLiteralExpr((String)String.class.cast(value)));
    }
}

