/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.List;
import java.util.function.Function;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.regex.ARegexIterator;
import net.sf.saxon.regex.ATokenIterator;
import net.sf.saxon.regex.RECompiler;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.regex.RESyntaxException;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;

public class ARegularExpression
implements RegularExpression {
    UnicodeString rawPattern;
    String rawFlags;
    REProgram regex;

    public ARegularExpression(UnicodeString pattern, String flags, String hostLanguage, List<String> warnings, Configuration config) throws XPathException {
        REFlags reFlags;
        this.rawFlags = flags;
        try {
            reFlags = new REFlags(flags, hostLanguage);
        }
        catch (RESyntaxException err) {
            throw new XPathException(err.getMessage(), "FORX0001");
        }
        try {
            this.rawPattern = pattern;
            RECompiler comp2 = new RECompiler();
            comp2.setFlags(reFlags);
            this.regex = comp2.compile(this.rawPattern);
            if (warnings != null) {
                warnings.addAll(comp2.getWarnings());
            }
            if (config != null) {
                this.regex.setBacktrackingLimit(config.getConfigurationProperty(Feature.REGEX_BACKTRACKING_LIMIT));
            }
        }
        catch (RESyntaxException err) {
            throw new XPathException(err.getMessage(), "FORX0002");
        }
    }

    public static ARegularExpression compile(String pattern, String flags) {
        try {
            return new ARegularExpression(BMPString.of(pattern), flags, "XP31", null, null);
        }
        catch (XPathException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ARegularExpression compile(UnicodeString pattern, String flags) {
        try {
            return new ARegularExpression(pattern, flags, "XP31", null, null);
        }
        catch (XPathException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean matches(UnicodeString input) {
        if (input.isEmpty() && this.regex.isNullable()) {
            return true;
        }
        REMatcher matcher = new REMatcher(this.regex);
        return matcher.isAnchoredMatch(input.tidy());
    }

    @Override
    public boolean containsMatch(UnicodeString input) {
        REMatcher matcher = new REMatcher(this.regex);
        return matcher.match(input.tidy(), 0);
    }

    @Override
    public AtomicIterator tokenize(UnicodeString input) {
        return new ATokenIterator(input.tidy(), new REMatcher(this.regex));
    }

    @Override
    public RegexIterator analyze(UnicodeString input) {
        return new ARegexIterator(input.tidy(), this.rawPattern, new REMatcher(this.regex));
    }

    @Override
    public UnicodeString replace(UnicodeString input, UnicodeString replacement) throws XPathException {
        REMatcher matcher = new REMatcher(this.regex);
        try {
            return matcher.replace(input.tidy(), replacement);
        }
        catch (RESyntaxException err) {
            throw new XPathException(err.getMessage(), "FORX0004");
        }
    }

    @Override
    public UnicodeString replaceWith(UnicodeString input, Function<UnicodeString, UnicodeString> replacer) throws XPathException {
        REMatcher matcher = new REMatcher(this.regex);
        try {
            return matcher.replaceWith(input.tidy(), replacer);
        }
        catch (RESyntaxException err) {
            throw new XPathException(err.getMessage(), "FORX0004");
        }
    }

    @Override
    public String getFlags() {
        return this.rawFlags;
    }
}

