/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typeinference.constraintformulas;

import com.github.javaparser.resolution.types.ResolvedIntersectionType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.NullType;
import com.github.javaparser.symbolsolver.resolution.typeinference.BoundSet;
import com.github.javaparser.symbolsolver.resolution.typeinference.ConstraintFormula;
import com.github.javaparser.symbolsolver.resolution.typeinference.TypeHelper;
import com.github.javaparser.symbolsolver.resolution.typeinference.bounds.SubtypeOfBound;

public class TypeSubtypeOfType
extends ConstraintFormula {
    private ResolvedType S;
    private ResolvedType T;
    private TypeSolver typeSolver;

    public TypeSubtypeOfType(TypeSolver typeSolver, ResolvedType S, ResolvedType T) {
        this.typeSolver = typeSolver;
        this.S = S;
        this.T = T;
    }

    @Override
    public ConstraintFormula.ReductionResult reduce(BoundSet currentBoundSet) {
        if (TypeHelper.isProperType(this.S) && TypeHelper.isProperType(this.T)) {
            if (this.T.isAssignableBy(this.S)) {
                return ConstraintFormula.ReductionResult.trueResult();
            }
            return ConstraintFormula.ReductionResult.falseResult();
        }
        if (this.S instanceof NullType) {
            return ConstraintFormula.ReductionResult.trueResult();
        }
        if (this.T instanceof NullType) {
            return ConstraintFormula.ReductionResult.falseResult();
        }
        if (this.S.isInferenceVariable()) {
            return ConstraintFormula.ReductionResult.oneBound(new SubtypeOfBound(this.S, this.T));
        }
        if (this.T.isInferenceVariable()) {
            return ConstraintFormula.ReductionResult.oneBound(new SubtypeOfBound(this.S, this.T));
        }
        if (this.T.isTypeVariable()) {
            if (this.S instanceof ResolvedIntersectionType) {
                throw new UnsupportedOperationException();
            }
            if (this.T.asTypeVariable().asTypeParameter().hasLowerBound()) {
                return ConstraintFormula.ReductionResult.oneConstraint(new TypeSubtypeOfType(this.typeSolver, this.S, this.T.asTypeVariable().asTypeParameter().getLowerBound()));
            }
            return ConstraintFormula.ReductionResult.falseResult();
        }
        throw new UnsupportedOperationException("S = " + this.S + ", T = " + this.T);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSubtypeOfType that = (TypeSubtypeOfType)o;
        if (!this.S.equals(that.S)) {
            return false;
        }
        return this.T.equals(that.T);
    }

    public int hashCode() {
        int result = this.S.hashCode();
        result = 31 * result + this.T.hashCode();
        return result;
    }

    public String toString() {
        return "TypeSubtypeOfType{S=" + this.S + ", T=" + this.T + '}';
    }
}

