/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typeinference;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.types.ResolvedIntersectionType;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedWildcard;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.logic.FunctionalInterfaceLogic;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.resolution.typeinference.ExpressionHelper;
import com.github.javaparser.symbolsolver.resolution.typeinference.InferenceVariable;
import com.github.javaparser.symbolsolver.resolution.typeinference.MethodType;
import com.github.javaparser.utils.Pair;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class TypeHelper {
    public static boolean isProperType(ResolvedType type) {
        if (type instanceof InferenceVariable) {
            return false;
        }
        if (type instanceof ResolvedReferenceType) {
            ResolvedReferenceType referenceType = (ResolvedReferenceType)type;
            return referenceType.typeParametersValues().stream().allMatch(it -> TypeHelper.isProperType(it));
        }
        if (type instanceof ResolvedWildcard) {
            ResolvedWildcard wildcard = (ResolvedWildcard)type;
            if (wildcard.isBounded()) {
                return TypeHelper.isProperType(wildcard.getBoundedType());
            }
            return true;
        }
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isTypeVariable()) {
            return false;
        }
        if (type.isArray()) {
            return TypeHelper.isProperType(type.asArrayType().getComponentType());
        }
        throw new UnsupportedOperationException(type.toString());
    }

    public static boolean isCompatibleInAStrictInvocationContext(Expression expression, ResolvedType t) {
        throw new UnsupportedOperationException();
    }

    public static boolean isCompatibleInALooseInvocationContext(TypeSolver typeSolver, Expression expression, ResolvedType t) {
        return TypeHelper.isCompatibleInALooseInvocationContext(JavaParserFacade.get(typeSolver).getType((Node)expression), t);
    }

    public static boolean isCompatibleInALooseInvocationContext(ResolvedType s, ResolvedType t) {
        if (s.equals(t)) {
            return true;
        }
        if (s.isPrimitive() && t.isPrimitive() && TypeHelper.areCompatibleThroughWideningPrimitiveConversion(s, t)) {
            return true;
        }
        if (s.isReferenceType() && t.isReferenceType() && TypeHelper.areCompatibleThroughWideningReferenceConversion(s, t)) {
            return true;
        }
        if (s.isPrimitive() && t.isReferenceType() && TypeHelper.areCompatibleThroughWideningReferenceConversion(TypeHelper.toBoxedType(s.asPrimitive()), t)) {
            return true;
        }
        if (s.isReferenceType() && s.asReferenceType().isUnboxable() && t.isPrimitive() && TypeHelper.areCompatibleThroughWideningPrimitiveConversion((ResolvedType)s.asReferenceType().toUnboxedType().get(), t)) {
            return true;
        }
        if (s.isNull() && t.isReferenceType()) {
            return true;
        }
        return t.isAssignableBy(s);
    }

    public static ResolvedType toBoxedType(ResolvedPrimitiveType primitiveType) {
        throw new UnsupportedOperationException();
    }

    public static ResolvedType toBoxedType(ResolvedPrimitiveType primitiveType, TypeSolver typeSolver) {
        SymbolReference<ResolvedReferenceTypeDeclaration> typeDeclaration = typeSolver.tryToSolveType(primitiveType.getBoxTypeQName());
        return new ReferenceTypeImpl(typeDeclaration.getCorrespondingDeclaration(), typeSolver);
    }

    public static boolean areCompatibleThroughWideningReferenceConversion(ResolvedType s, ResolvedType t) {
        Optional<ResolvedPrimitiveType> correspondingPrimitiveTypeForS = Arrays.stream(ResolvedPrimitiveType.values()).filter(pt -> pt.getBoxTypeQName().equals(s.asReferenceType().getQualifiedName())).findFirst();
        if (!correspondingPrimitiveTypeForS.isPresent()) {
            return false;
        }
        throw new UnsupportedOperationException("areCompatibleThroughWideningReferenceConversion s=" + s + ", t=" + t);
    }

    public static boolean areCompatibleThroughWideningPrimitiveConversion(ResolvedType s, ResolvedType t) {
        if (s.isPrimitive() && t.isPrimitive()) {
            return s.isAssignableBy(t);
        }
        return false;
    }

    public static Set<InferenceVariable> usedInferenceVariables(ResolvedType type) {
        if (type.isInferenceVariable()) {
            return new HashSet<InferenceVariable>(Arrays.asList((InferenceVariable)type));
        }
        if (type.isReferenceType()) {
            HashSet<InferenceVariable> res = new HashSet<InferenceVariable>();
            for (ResolvedType tp : type.asReferenceType().typeParametersValues()) {
                res.addAll(TypeHelper.usedInferenceVariables(tp));
            }
            return res;
        }
        throw new UnsupportedOperationException(type.toString());
    }

    public static ResolvedType leastUpperBound(Set<ResolvedType> types) {
        if (types.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (types.size() == 1) {
            return (ResolvedType)types.stream().findFirst().get();
        }
        throw new UnsupportedOperationException();
    }

    public static Pair<ResolvedType, Boolean> groundTargetTypeOfLambda(LambdaExpr lambdaExpr, ResolvedType T, TypeSolver typeSolver) {
        boolean used18_5_3 = false;
        boolean wildcardParameterized = T.asReferenceType().typeParametersValues().stream().anyMatch(tp -> tp.isWildcard());
        if (wildcardParameterized) {
            if (ExpressionHelper.isExplicitlyTyped(lambdaExpr)) {
                used18_5_3 = true;
                throw new UnsupportedOperationException();
            }
            return new Pair((Object)TypeHelper.nonWildcardParameterizationOf(T.asReferenceType(), typeSolver), (Object)used18_5_3);
        }
        return new Pair((Object)T, (Object)used18_5_3);
    }

    private static ResolvedReferenceType nonWildcardParameterizationOf(ResolvedReferenceType originalType, TypeSolver typeSolver) {
        ResolvedReferenceTypeDeclaration originalTypeDeclaration = (ResolvedReferenceTypeDeclaration)originalType.getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty."));
        LinkedList<ResolvedType> TIs = new LinkedList<ResolvedType>();
        List AIs = originalType.typeParametersValues();
        List TPs = originalTypeDeclaration.getTypeParameters();
        ReferenceTypeImpl object = new ReferenceTypeImpl(typeSolver.getSolvedJavaLangObject(), typeSolver);
        for (int i = 0; i < AIs.size(); ++i) {
            ResolvedType Ai = (ResolvedType)AIs.get(i);
            Object Ti = null;
            if (!Ai.isWildcard()) {
                Ti = Ai;
            }
            if (Ti == null && Ai.isWildcard() && Ai.asWildcard().mention(originalTypeDeclaration.getTypeParameters())) {
                throw new IllegalArgumentException();
            }
            if (Ti == null) {
                ReferenceTypeImpl Bi;
                ReferenceTypeImpl referenceTypeImpl = Bi = ((ResolvedTypeParameterDeclaration)TPs.get(i)).hasLowerBound() ? ((ResolvedTypeParameterDeclaration)TPs.get(i)).getLowerBound() : object;
                if (Ai.isWildcard() && !Ai.asWildcard().isBounded()) {
                    Ti = Bi;
                } else if (Ai.isWildcard() && Ai.asWildcard().isUpperBounded()) {
                    ResolvedType Ui = Ai.asWildcard().getBoundedType();
                    Ti = TypeHelper.glb(new HashSet<ResolvedType>(Arrays.asList(new ResolvedType[]{Ui, Bi})));
                } else if (Ai.isWildcard() && Ai.asWildcard().isLowerBounded()) {
                    Ti = Ai.asWildcard().getBoundedType();
                } else {
                    throw new RuntimeException("This should not happen");
                }
            }
            TIs.add((ResolvedType)Ti);
        }
        return new ReferenceTypeImpl(originalTypeDeclaration, TIs, typeSolver);
    }

    public static MethodType getFunctionType(ResolvedType type) {
        Optional<MethodUsage> mu = FunctionalInterfaceLogic.getFunctionalMethod(type);
        if (mu.isPresent()) {
            return MethodType.fromMethodUsage(mu.get());
        }
        throw new IllegalArgumentException();
    }

    public static ResolvedType glb(Set<ResolvedType> types) {
        if (types.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (types.size() == 1) {
            return types.iterator().next();
        }
        return new ResolvedIntersectionType(types);
    }
}

