/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.cache;

import com.github.javaparser.symbolsolver.cache.Cache;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;

public class InMemoryCache<K, V>
implements Cache<K, V> {
    private final Map<K, V> mappedValues = new WeakHashMap();

    public static <expectedK, expectedV> InMemoryCache<expectedK, expectedV> create() {
        return new InMemoryCache();
    }

    @Override
    public void put(K key, V value) {
        this.mappedValues.put(key, value);
    }

    @Override
    public Optional<V> get(K key) {
        return Optional.ofNullable(this.mappedValues.get(key));
    }

    @Override
    public void remove(K key) {
        this.mappedValues.remove(key);
    }

    @Override
    public void removeAll() {
        this.mappedValues.clear();
    }

    @Override
    public boolean contains(K key) {
        return this.mappedValues.containsKey(key);
    }

    @Override
    public long size() {
        return this.mappedValues.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mappedValues.isEmpty();
    }
}

