/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog/log"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type LPollData struct {
	SourceAddress          *KnxAddress
	TargetAddress          []int8
	NumberExpectedPollData uint8
	Parent                 *LDataFrame
}

// The corresponding interface
type ILPollData interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

///////////////////////////////////////////////////////////
// Accessors for discriminator values.
///////////////////////////////////////////////////////////
func (m *LPollData) NotAckFrame() bool {
	return true
}

func (m *LPollData) Polling() bool {
	return true
}

func (m *LPollData) InitializeParent(parent *LDataFrame, frameType bool, notRepeated bool, priority CEMIPriority, acknowledgeRequested bool, errorFlag bool) {
	m.Parent.FrameType = frameType
	m.Parent.NotRepeated = notRepeated
	m.Parent.Priority = priority
	m.Parent.AcknowledgeRequested = acknowledgeRequested
	m.Parent.ErrorFlag = errorFlag
}

func NewLPollData(sourceAddress *KnxAddress, targetAddress []int8, numberExpectedPollData uint8, frameType bool, notRepeated bool, priority CEMIPriority, acknowledgeRequested bool, errorFlag bool) *LDataFrame {
	child := &LPollData{
		SourceAddress:          sourceAddress,
		TargetAddress:          targetAddress,
		NumberExpectedPollData: numberExpectedPollData,
		Parent:                 NewLDataFrame(frameType, notRepeated, priority, acknowledgeRequested, errorFlag),
	}
	child.Parent.Child = child
	return child.Parent
}

func CastLPollData(structType interface{}) *LPollData {
	castFunc := func(typ interface{}) *LPollData {
		if casted, ok := typ.(LPollData); ok {
			return &casted
		}
		if casted, ok := typ.(*LPollData); ok {
			return casted
		}
		if casted, ok := typ.(LDataFrame); ok {
			return CastLPollData(casted.Child)
		}
		if casted, ok := typ.(*LDataFrame); ok {
			return CastLPollData(casted.Child)
		}
		return nil
	}
	return castFunc(structType)
}

func (m *LPollData) GetTypeName() string {
	return "LPollData"
}

func (m *LPollData) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *LPollData) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.Parent.ParentLengthInBits())

	// Simple field (sourceAddress)
	lengthInBits += m.SourceAddress.LengthInBits()

	// Array field
	if len(m.TargetAddress) > 0 {
		lengthInBits += 8 * uint16(len(m.TargetAddress))
	}

	// Reserved Field (reserved)
	lengthInBits += 4

	// Simple field (numberExpectedPollData)
	lengthInBits += 6

	return lengthInBits
}

func (m *LPollData) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func LPollDataParse(readBuffer utils.ReadBuffer) (*LDataFrame, error) {
	if pullErr := readBuffer.PullContext("LPollData"); pullErr != nil {
		return nil, pullErr
	}

	// Simple Field (sourceAddress)
	if pullErr := readBuffer.PullContext("sourceAddress"); pullErr != nil {
		return nil, pullErr
	}
	sourceAddress, _sourceAddressErr := KnxAddressParse(readBuffer)
	if _sourceAddressErr != nil {
		return nil, errors.Wrap(_sourceAddressErr, "Error parsing 'sourceAddress' field")
	}
	if closeErr := readBuffer.CloseContext("sourceAddress"); closeErr != nil {
		return nil, closeErr
	}

	// Array field (targetAddress)
	if pullErr := readBuffer.PullContext("targetAddress", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, pullErr
	}
	// Count array
	targetAddress := make([]int8, uint16(2))
	for curItem := uint16(0); curItem < uint16(uint16(2)); curItem++ {
		_item, _err := readBuffer.ReadInt8("", 8)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'targetAddress' field")
		}
		targetAddress[curItem] = _item
	}
	if closeErr := readBuffer.CloseContext("targetAddress", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, closeErr
	}

	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint8("reserved", 4)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field")
		}
		if reserved != uint8(0x00) {
			log.Info().Fields(map[string]interface{}{
				"expected value": uint8(0x00),
				"got value":      reserved,
			}).Msg("Got unexpected response.")
		}
	}

	// Simple Field (numberExpectedPollData)
	numberExpectedPollData, _numberExpectedPollDataErr := readBuffer.ReadUint8("numberExpectedPollData", 6)
	if _numberExpectedPollDataErr != nil {
		return nil, errors.Wrap(_numberExpectedPollDataErr, "Error parsing 'numberExpectedPollData' field")
	}

	if closeErr := readBuffer.CloseContext("LPollData"); closeErr != nil {
		return nil, closeErr
	}

	// Create a partially initialized instance
	_child := &LPollData{
		SourceAddress:          sourceAddress,
		TargetAddress:          targetAddress,
		NumberExpectedPollData: numberExpectedPollData,
		Parent:                 &LDataFrame{},
	}
	_child.Parent.Child = _child
	return _child.Parent, nil
}

func (m *LPollData) Serialize(writeBuffer utils.WriteBuffer) error {
	ser := func() error {
		if pushErr := writeBuffer.PushContext("LPollData"); pushErr != nil {
			return pushErr
		}

		// Simple Field (sourceAddress)
		if pushErr := writeBuffer.PushContext("sourceAddress"); pushErr != nil {
			return pushErr
		}
		_sourceAddressErr := m.SourceAddress.Serialize(writeBuffer)
		if popErr := writeBuffer.PopContext("sourceAddress"); popErr != nil {
			return popErr
		}
		if _sourceAddressErr != nil {
			return errors.Wrap(_sourceAddressErr, "Error serializing 'sourceAddress' field")
		}

		// Array Field (targetAddress)
		if m.TargetAddress != nil {
			if pushErr := writeBuffer.PushContext("targetAddress", utils.WithRenderAsList(true)); pushErr != nil {
				return pushErr
			}
			for _, _element := range m.TargetAddress {
				_elementErr := writeBuffer.WriteInt8("", 8, _element)
				if _elementErr != nil {
					return errors.Wrap(_elementErr, "Error serializing 'targetAddress' field")
				}
			}
			if popErr := writeBuffer.PopContext("targetAddress", utils.WithRenderAsList(true)); popErr != nil {
				return popErr
			}
		}

		// Reserved Field (reserved)
		{
			_err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00))
			if _err != nil {
				return errors.Wrap(_err, "Error serializing 'reserved' field")
			}
		}

		// Simple Field (numberExpectedPollData)
		numberExpectedPollData := uint8(m.NumberExpectedPollData)
		_numberExpectedPollDataErr := writeBuffer.WriteUint8("numberExpectedPollData", 6, (numberExpectedPollData))
		if _numberExpectedPollDataErr != nil {
			return errors.Wrap(_numberExpectedPollDataErr, "Error serializing 'numberExpectedPollData' field")
		}

		if popErr := writeBuffer.PopContext("LPollData"); popErr != nil {
			return popErr
		}
		return nil
	}
	return m.Parent.SerializeParent(writeBuffer, m, ser)
}

func (m *LPollData) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
