/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type ApduDataIndividualAddressResponse struct {
	Parent *ApduData
}

// The corresponding interface
type IApduDataIndividualAddressResponse interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

///////////////////////////////////////////////////////////
// Accessors for discriminator values.
///////////////////////////////////////////////////////////
func (m *ApduDataIndividualAddressResponse) ApciType() uint8 {
	return 0x5
}

func (m *ApduDataIndividualAddressResponse) InitializeParent(parent *ApduData) {
}

func NewApduDataIndividualAddressResponse() *ApduData {
	child := &ApduDataIndividualAddressResponse{
		Parent: NewApduData(),
	}
	child.Parent.Child = child
	return child.Parent
}

func CastApduDataIndividualAddressResponse(structType interface{}) *ApduDataIndividualAddressResponse {
	castFunc := func(typ interface{}) *ApduDataIndividualAddressResponse {
		if casted, ok := typ.(ApduDataIndividualAddressResponse); ok {
			return &casted
		}
		if casted, ok := typ.(*ApduDataIndividualAddressResponse); ok {
			return casted
		}
		if casted, ok := typ.(ApduData); ok {
			return CastApduDataIndividualAddressResponse(casted.Child)
		}
		if casted, ok := typ.(*ApduData); ok {
			return CastApduDataIndividualAddressResponse(casted.Child)
		}
		return nil
	}
	return castFunc(structType)
}

func (m *ApduDataIndividualAddressResponse) GetTypeName() string {
	return "ApduDataIndividualAddressResponse"
}

func (m *ApduDataIndividualAddressResponse) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *ApduDataIndividualAddressResponse) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.Parent.ParentLengthInBits())

	return lengthInBits
}

func (m *ApduDataIndividualAddressResponse) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func ApduDataIndividualAddressResponseParse(readBuffer utils.ReadBuffer) (*ApduData, error) {
	if pullErr := readBuffer.PullContext("ApduDataIndividualAddressResponse"); pullErr != nil {
		return nil, pullErr
	}

	if closeErr := readBuffer.CloseContext("ApduDataIndividualAddressResponse"); closeErr != nil {
		return nil, closeErr
	}

	// Create a partially initialized instance
	_child := &ApduDataIndividualAddressResponse{
		Parent: &ApduData{},
	}
	_child.Parent.Child = _child
	return _child.Parent, nil
}

func (m *ApduDataIndividualAddressResponse) Serialize(writeBuffer utils.WriteBuffer) error {
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataIndividualAddressResponse"); pushErr != nil {
			return pushErr
		}

		if popErr := writeBuffer.PopContext("ApduDataIndividualAddressResponse"); popErr != nil {
			return popErr
		}
		return nil
	}
	return m.Parent.SerializeParent(writeBuffer, m, ser)
}

func (m *ApduDataIndividualAddressResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
