/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type SysexCommand struct {
	Child ISysexCommandChild
}

// The corresponding interface
type ISysexCommand interface {
	CommandType() uint8
	Response() bool
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

type ISysexCommandParent interface {
	SerializeParent(writeBuffer utils.WriteBuffer, child ISysexCommand, serializeChildFunction func() error) error
	GetTypeName() string
}

type ISysexCommandChild interface {
	Serialize(writeBuffer utils.WriteBuffer) error
	InitializeParent(parent *SysexCommand)
	GetTypeName() string
	ISysexCommand
}

func NewSysexCommand() *SysexCommand {
	return &SysexCommand{}
}

func CastSysexCommand(structType interface{}) *SysexCommand {
	castFunc := func(typ interface{}) *SysexCommand {
		if casted, ok := typ.(SysexCommand); ok {
			return &casted
		}
		if casted, ok := typ.(*SysexCommand); ok {
			return casted
		}
		return nil
	}
	return castFunc(structType)
}

func (m *SysexCommand) GetTypeName() string {
	return "SysexCommand"
}

func (m *SysexCommand) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *SysexCommand) LengthInBitsConditional(lastItem bool) uint16 {
	return m.Child.LengthInBits()
}

func (m *SysexCommand) ParentLengthInBits() uint16 {
	lengthInBits := uint16(0)
	// Discriminator Field (commandType)
	lengthInBits += 8

	return lengthInBits
}

func (m *SysexCommand) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func SysexCommandParse(readBuffer utils.ReadBuffer, response bool) (*SysexCommand, error) {
	if pullErr := readBuffer.PullContext("SysexCommand"); pullErr != nil {
		return nil, pullErr
	}

	// Discriminator Field (commandType) (Used as input to a switch field)
	commandType, _commandTypeErr := readBuffer.ReadUint8("commandType", 8)
	if _commandTypeErr != nil {
		return nil, errors.Wrap(_commandTypeErr, "Error parsing 'commandType' field")
	}

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _parent *SysexCommand
	var typeSwitchError error
	switch {
	case commandType == 0x00: // SysexCommandExendedId
		_parent, typeSwitchError = SysexCommandExendedIdParse(readBuffer)
	case commandType == 0x69 && response == false: // SysexCommandAnalogMappingQueryRequest
		_parent, typeSwitchError = SysexCommandAnalogMappingQueryRequestParse(readBuffer)
	case commandType == 0x69 && response == true: // SysexCommandAnalogMappingQueryResponse
		_parent, typeSwitchError = SysexCommandAnalogMappingQueryResponseParse(readBuffer)
	case commandType == 0x6A: // SysexCommandAnalogMappingResponse
		_parent, typeSwitchError = SysexCommandAnalogMappingResponseParse(readBuffer)
	case commandType == 0x6B: // SysexCommandCapabilityQuery
		_parent, typeSwitchError = SysexCommandCapabilityQueryParse(readBuffer)
	case commandType == 0x6C: // SysexCommandCapabilityResponse
		_parent, typeSwitchError = SysexCommandCapabilityResponseParse(readBuffer)
	case commandType == 0x6D: // SysexCommandPinStateQuery
		_parent, typeSwitchError = SysexCommandPinStateQueryParse(readBuffer)
	case commandType == 0x6E: // SysexCommandPinStateResponse
		_parent, typeSwitchError = SysexCommandPinStateResponseParse(readBuffer)
	case commandType == 0x6F: // SysexCommandExtendedAnalog
		_parent, typeSwitchError = SysexCommandExtendedAnalogParse(readBuffer)
	case commandType == 0x71: // SysexCommandStringData
		_parent, typeSwitchError = SysexCommandStringDataParse(readBuffer)
	case commandType == 0x79 && response == false: // SysexCommandReportFirmwareRequest
		_parent, typeSwitchError = SysexCommandReportFirmwareRequestParse(readBuffer)
	case commandType == 0x79 && response == true: // SysexCommandReportFirmwareResponse
		_parent, typeSwitchError = SysexCommandReportFirmwareResponseParse(readBuffer)
	case commandType == 0x7A: // SysexCommandSamplingInterval
		_parent, typeSwitchError = SysexCommandSamplingIntervalParse(readBuffer)
	case commandType == 0x7E: // SysexCommandSysexNonRealtime
		_parent, typeSwitchError = SysexCommandSysexNonRealtimeParse(readBuffer)
	case commandType == 0x7F: // SysexCommandSysexRealtime
		_parent, typeSwitchError = SysexCommandSysexRealtimeParse(readBuffer)
	default:
		// TODO: return actual type
		typeSwitchError = errors.New("Unmapped type")
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch.")
	}

	if closeErr := readBuffer.CloseContext("SysexCommand"); closeErr != nil {
		return nil, closeErr
	}

	// Finish initializing
	_parent.Child.InitializeParent(_parent)
	return _parent, nil
}

func (m *SysexCommand) Serialize(writeBuffer utils.WriteBuffer) error {
	return m.Child.Serialize(writeBuffer)
}

func (m *SysexCommand) SerializeParent(writeBuffer utils.WriteBuffer, child ISysexCommand, serializeChildFunction func() error) error {
	if pushErr := writeBuffer.PushContext("SysexCommand"); pushErr != nil {
		return pushErr
	}

	// Discriminator Field (commandType) (Used as input to a switch field)
	commandType := uint8(child.CommandType())
	_commandTypeErr := writeBuffer.WriteUint8("commandType", 8, (commandType))

	if _commandTypeErr != nil {
		return errors.Wrap(_commandTypeErr, "Error serializing 'commandType' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	_typeSwitchErr := serializeChildFunction()
	if _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("SysexCommand"); popErr != nil {
		return popErr
	}
	return nil
}

func (m *SysexCommand) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
