/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"fmt"
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const DF1SymbolMessageFrame_MESSAGEEND uint8 = 0x10
const DF1SymbolMessageFrame_ENDTRANSACTION uint8 = 0x03

// The data-structure of this message
type DF1SymbolMessageFrame struct {
	DestinationAddress uint8
	SourceAddress      uint8
	Command            *DF1Command
	Parent             *DF1Symbol
}

// The corresponding interface
type IDF1SymbolMessageFrame interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

///////////////////////////////////////////////////////////
// Accessors for discriminator values.
///////////////////////////////////////////////////////////
func (m *DF1SymbolMessageFrame) SymbolType() uint8 {
	return 0x02
}

func (m *DF1SymbolMessageFrame) InitializeParent(parent *DF1Symbol) {
}

func NewDF1SymbolMessageFrame(destinationAddress uint8, sourceAddress uint8, command *DF1Command) *DF1Symbol {
	child := &DF1SymbolMessageFrame{
		DestinationAddress: destinationAddress,
		SourceAddress:      sourceAddress,
		Command:            command,
		Parent:             NewDF1Symbol(),
	}
	child.Parent.Child = child
	return child.Parent
}

func CastDF1SymbolMessageFrame(structType interface{}) *DF1SymbolMessageFrame {
	castFunc := func(typ interface{}) *DF1SymbolMessageFrame {
		if casted, ok := typ.(DF1SymbolMessageFrame); ok {
			return &casted
		}
		if casted, ok := typ.(*DF1SymbolMessageFrame); ok {
			return casted
		}
		if casted, ok := typ.(DF1Symbol); ok {
			return CastDF1SymbolMessageFrame(casted.Child)
		}
		if casted, ok := typ.(*DF1Symbol); ok {
			return CastDF1SymbolMessageFrame(casted.Child)
		}
		return nil
	}
	return castFunc(structType)
}

func (m *DF1SymbolMessageFrame) GetTypeName() string {
	return "DF1SymbolMessageFrame"
}

func (m *DF1SymbolMessageFrame) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *DF1SymbolMessageFrame) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.Parent.ParentLengthInBits())

	// Simple field (destinationAddress)
	lengthInBits += 8

	// Simple field (sourceAddress)
	lengthInBits += 8

	// Simple field (command)
	lengthInBits += m.Command.LengthInBits()

	// Const Field (messageEnd)
	lengthInBits += 8

	// Const Field (endTransaction)
	lengthInBits += 8

	// Checksum Field (checksum)
	lengthInBits += 16

	return lengthInBits
}

func (m *DF1SymbolMessageFrame) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func DF1SymbolMessageFrameParse(readBuffer utils.ReadBuffer) (*DF1Symbol, error) {
	if pullErr := readBuffer.PullContext("DF1SymbolMessageFrame"); pullErr != nil {
		return nil, pullErr
	}

	// Simple Field (destinationAddress)
	destinationAddress, _destinationAddressErr := readBuffer.ReadUint8("destinationAddress", 8)
	if _destinationAddressErr != nil {
		return nil, errors.Wrap(_destinationAddressErr, "Error parsing 'destinationAddress' field")
	}

	// Simple Field (sourceAddress)
	sourceAddress, _sourceAddressErr := readBuffer.ReadUint8("sourceAddress", 8)
	if _sourceAddressErr != nil {
		return nil, errors.Wrap(_sourceAddressErr, "Error parsing 'sourceAddress' field")
	}

	// Simple Field (command)
	if pullErr := readBuffer.PullContext("command"); pullErr != nil {
		return nil, pullErr
	}
	command, _commandErr := DF1CommandParse(readBuffer)
	if _commandErr != nil {
		return nil, errors.Wrap(_commandErr, "Error parsing 'command' field")
	}
	if closeErr := readBuffer.CloseContext("command"); closeErr != nil {
		return nil, closeErr
	}

	// Const Field (messageEnd)
	messageEnd, _messageEndErr := readBuffer.ReadUint8("messageEnd", 8)
	if _messageEndErr != nil {
		return nil, errors.Wrap(_messageEndErr, "Error parsing 'messageEnd' field")
	}
	if messageEnd != DF1SymbolMessageFrame_MESSAGEEND {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", DF1SymbolMessageFrame_MESSAGEEND) + " but got " + fmt.Sprintf("%d", messageEnd))
	}

	// Const Field (endTransaction)
	endTransaction, _endTransactionErr := readBuffer.ReadUint8("endTransaction", 8)
	if _endTransactionErr != nil {
		return nil, errors.Wrap(_endTransactionErr, "Error parsing 'endTransaction' field")
	}
	if endTransaction != DF1SymbolMessageFrame_ENDTRANSACTION {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", DF1SymbolMessageFrame_ENDTRANSACTION) + " but got " + fmt.Sprintf("%d", endTransaction))
	}

	// Checksum Field (checksum)
	{
		checksumRef, _checksumRefErr := readBuffer.ReadUint16("checksum", 16)
		if _checksumRefErr != nil {
			return nil, errors.Wrap(_checksumRefErr, "Error parsing 'checksum' field")
		}
		checksum, _checksumErr := DF1UtilsCrcCheck(destinationAddress, sourceAddress, command)
		if _checksumErr != nil {
			return nil, errors.Wrap(_checksumErr, "Error parsing 'checksum' field")
		}
		if checksum != checksumRef {
			return nil, errors.Errorf("Checksum verification failed. Expected %d but got %d", (checksumRef & 0xFFFF), (checksum & 0xFFFF))
		}
	}

	if closeErr := readBuffer.CloseContext("DF1SymbolMessageFrame"); closeErr != nil {
		return nil, closeErr
	}

	// Create a partially initialized instance
	_child := &DF1SymbolMessageFrame{
		DestinationAddress: destinationAddress,
		SourceAddress:      sourceAddress,
		Command:            command,
		Parent:             &DF1Symbol{},
	}
	_child.Parent.Child = _child
	return _child.Parent, nil
}

func (m *DF1SymbolMessageFrame) Serialize(writeBuffer utils.WriteBuffer) error {
	ser := func() error {
		if pushErr := writeBuffer.PushContext("DF1SymbolMessageFrame"); pushErr != nil {
			return pushErr
		}

		// Simple Field (destinationAddress)
		destinationAddress := uint8(m.DestinationAddress)
		_destinationAddressErr := writeBuffer.WriteUint8("destinationAddress", 8, (destinationAddress))
		if _destinationAddressErr != nil {
			return errors.Wrap(_destinationAddressErr, "Error serializing 'destinationAddress' field")
		}

		// Simple Field (sourceAddress)
		sourceAddress := uint8(m.SourceAddress)
		_sourceAddressErr := writeBuffer.WriteUint8("sourceAddress", 8, (sourceAddress))
		if _sourceAddressErr != nil {
			return errors.Wrap(_sourceAddressErr, "Error serializing 'sourceAddress' field")
		}

		// Simple Field (command)
		if pushErr := writeBuffer.PushContext("command"); pushErr != nil {
			return pushErr
		}
		_commandErr := m.Command.Serialize(writeBuffer)
		if popErr := writeBuffer.PopContext("command"); popErr != nil {
			return popErr
		}
		if _commandErr != nil {
			return errors.Wrap(_commandErr, "Error serializing 'command' field")
		}

		// Const Field (messageEnd)
		_messageEndErr := writeBuffer.WriteUint8("messageEnd", 8, 0x10)
		if _messageEndErr != nil {
			return errors.Wrap(_messageEndErr, "Error serializing 'messageEnd' field")
		}

		// Const Field (endTransaction)
		_endTransactionErr := writeBuffer.WriteUint8("endTransaction", 8, 0x03)
		if _endTransactionErr != nil {
			return errors.Wrap(_endTransactionErr, "Error serializing 'endTransaction' field")
		}

		// Checksum Field (checksum) (Calculated)
		{
			_checksum, _checksumErr := DF1UtilsCrcCheck(m.DestinationAddress, m.SourceAddress, m.Command)
			if _checksumErr != nil {
				return errors.Wrap(_checksumErr, "Error serializing 'checksum' field")
			}
			_checksumErr = writeBuffer.WriteUint16("checksum", 16, (_checksum))
			if _checksumErr != nil {
				return errors.Wrap(_checksumErr, "Error serializing 'checksum' field")
			}
		}

		if popErr := writeBuffer.PopContext("DF1SymbolMessageFrame"); popErr != nil {
			return popErr
		}
		return nil
	}
	return m.Parent.SerializeParent(writeBuffer, m, ser)
}

func (m *DF1SymbolMessageFrame) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
