/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog/log"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type State struct {
	InitCommand         bool
	UpdCommand          bool
	TimestampAdded      bool
	HighPriorityCommand bool
	SystemCommand       bool
	AdsCommand          bool
	NoReturn            bool
	Response            bool
	Broadcast           bool
}

// The corresponding interface
type IState interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

func NewState(initCommand bool, updCommand bool, timestampAdded bool, highPriorityCommand bool, systemCommand bool, adsCommand bool, noReturn bool, response bool, broadcast bool) *State {
	return &State{InitCommand: initCommand, UpdCommand: updCommand, TimestampAdded: timestampAdded, HighPriorityCommand: highPriorityCommand, SystemCommand: systemCommand, AdsCommand: adsCommand, NoReturn: noReturn, Response: response, Broadcast: broadcast}
}

func CastState(structType interface{}) *State {
	castFunc := func(typ interface{}) *State {
		if casted, ok := typ.(State); ok {
			return &casted
		}
		if casted, ok := typ.(*State); ok {
			return casted
		}
		return nil
	}
	return castFunc(structType)
}

func (m *State) GetTypeName() string {
	return "State"
}

func (m *State) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *State) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(0)

	// Simple field (initCommand)
	lengthInBits += 1

	// Simple field (updCommand)
	lengthInBits += 1

	// Simple field (timestampAdded)
	lengthInBits += 1

	// Simple field (highPriorityCommand)
	lengthInBits += 1

	// Simple field (systemCommand)
	lengthInBits += 1

	// Simple field (adsCommand)
	lengthInBits += 1

	// Simple field (noReturn)
	lengthInBits += 1

	// Simple field (response)
	lengthInBits += 1

	// Simple field (broadcast)
	lengthInBits += 1

	// Reserved Field (reserved)
	lengthInBits += 7

	return lengthInBits
}

func (m *State) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func StateParse(readBuffer utils.ReadBuffer) (*State, error) {
	if pullErr := readBuffer.PullContext("State"); pullErr != nil {
		return nil, pullErr
	}

	// Simple Field (initCommand)
	initCommand, _initCommandErr := readBuffer.ReadBit("initCommand")
	if _initCommandErr != nil {
		return nil, errors.Wrap(_initCommandErr, "Error parsing 'initCommand' field")
	}

	// Simple Field (updCommand)
	updCommand, _updCommandErr := readBuffer.ReadBit("updCommand")
	if _updCommandErr != nil {
		return nil, errors.Wrap(_updCommandErr, "Error parsing 'updCommand' field")
	}

	// Simple Field (timestampAdded)
	timestampAdded, _timestampAddedErr := readBuffer.ReadBit("timestampAdded")
	if _timestampAddedErr != nil {
		return nil, errors.Wrap(_timestampAddedErr, "Error parsing 'timestampAdded' field")
	}

	// Simple Field (highPriorityCommand)
	highPriorityCommand, _highPriorityCommandErr := readBuffer.ReadBit("highPriorityCommand")
	if _highPriorityCommandErr != nil {
		return nil, errors.Wrap(_highPriorityCommandErr, "Error parsing 'highPriorityCommand' field")
	}

	// Simple Field (systemCommand)
	systemCommand, _systemCommandErr := readBuffer.ReadBit("systemCommand")
	if _systemCommandErr != nil {
		return nil, errors.Wrap(_systemCommandErr, "Error parsing 'systemCommand' field")
	}

	// Simple Field (adsCommand)
	adsCommand, _adsCommandErr := readBuffer.ReadBit("adsCommand")
	if _adsCommandErr != nil {
		return nil, errors.Wrap(_adsCommandErr, "Error parsing 'adsCommand' field")
	}

	// Simple Field (noReturn)
	noReturn, _noReturnErr := readBuffer.ReadBit("noReturn")
	if _noReturnErr != nil {
		return nil, errors.Wrap(_noReturnErr, "Error parsing 'noReturn' field")
	}

	// Simple Field (response)
	response, _responseErr := readBuffer.ReadBit("response")
	if _responseErr != nil {
		return nil, errors.Wrap(_responseErr, "Error parsing 'response' field")
	}

	// Simple Field (broadcast)
	broadcast, _broadcastErr := readBuffer.ReadBit("broadcast")
	if _broadcastErr != nil {
		return nil, errors.Wrap(_broadcastErr, "Error parsing 'broadcast' field")
	}

	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadInt8("reserved", 7)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field")
		}
		if reserved != int8(0x0) {
			log.Info().Fields(map[string]interface{}{
				"expected value": int8(0x0),
				"got value":      reserved,
			}).Msg("Got unexpected response.")
		}
	}

	if closeErr := readBuffer.CloseContext("State"); closeErr != nil {
		return nil, closeErr
	}

	// Create the instance
	return NewState(initCommand, updCommand, timestampAdded, highPriorityCommand, systemCommand, adsCommand, noReturn, response, broadcast), nil
}

func (m *State) Serialize(writeBuffer utils.WriteBuffer) error {
	if pushErr := writeBuffer.PushContext("State"); pushErr != nil {
		return pushErr
	}

	// Simple Field (initCommand)
	initCommand := bool(m.InitCommand)
	_initCommandErr := writeBuffer.WriteBit("initCommand", (initCommand))
	if _initCommandErr != nil {
		return errors.Wrap(_initCommandErr, "Error serializing 'initCommand' field")
	}

	// Simple Field (updCommand)
	updCommand := bool(m.UpdCommand)
	_updCommandErr := writeBuffer.WriteBit("updCommand", (updCommand))
	if _updCommandErr != nil {
		return errors.Wrap(_updCommandErr, "Error serializing 'updCommand' field")
	}

	// Simple Field (timestampAdded)
	timestampAdded := bool(m.TimestampAdded)
	_timestampAddedErr := writeBuffer.WriteBit("timestampAdded", (timestampAdded))
	if _timestampAddedErr != nil {
		return errors.Wrap(_timestampAddedErr, "Error serializing 'timestampAdded' field")
	}

	// Simple Field (highPriorityCommand)
	highPriorityCommand := bool(m.HighPriorityCommand)
	_highPriorityCommandErr := writeBuffer.WriteBit("highPriorityCommand", (highPriorityCommand))
	if _highPriorityCommandErr != nil {
		return errors.Wrap(_highPriorityCommandErr, "Error serializing 'highPriorityCommand' field")
	}

	// Simple Field (systemCommand)
	systemCommand := bool(m.SystemCommand)
	_systemCommandErr := writeBuffer.WriteBit("systemCommand", (systemCommand))
	if _systemCommandErr != nil {
		return errors.Wrap(_systemCommandErr, "Error serializing 'systemCommand' field")
	}

	// Simple Field (adsCommand)
	adsCommand := bool(m.AdsCommand)
	_adsCommandErr := writeBuffer.WriteBit("adsCommand", (adsCommand))
	if _adsCommandErr != nil {
		return errors.Wrap(_adsCommandErr, "Error serializing 'adsCommand' field")
	}

	// Simple Field (noReturn)
	noReturn := bool(m.NoReturn)
	_noReturnErr := writeBuffer.WriteBit("noReturn", (noReturn))
	if _noReturnErr != nil {
		return errors.Wrap(_noReturnErr, "Error serializing 'noReturn' field")
	}

	// Simple Field (response)
	response := bool(m.Response)
	_responseErr := writeBuffer.WriteBit("response", (response))
	if _responseErr != nil {
		return errors.Wrap(_responseErr, "Error serializing 'response' field")
	}

	// Simple Field (broadcast)
	broadcast := bool(m.Broadcast)
	_broadcastErr := writeBuffer.WriteBit("broadcast", (broadcast))
	if _broadcastErr != nil {
		return errors.Wrap(_broadcastErr, "Error serializing 'broadcast' field")
	}

	// Reserved Field (reserved)
	{
		_err := writeBuffer.WriteInt8("reserved", 7, int8(0x0))
		if _err != nil {
			return errors.Wrap(_err, "Error serializing 'reserved' field")
		}
	}

	if popErr := writeBuffer.PopContext("State"); popErr != nil {
		return popErr
	}
	return nil
}

func (m *State) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
