/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#include <stdio.h>
#include <plc4c/spi/evaluation_helper.h>
#include "alarm_message_object_push_type.h"

// Code generated by code-generation. DO NOT EDIT.


// Constant values.
static const uint8_t PLC4C_S7_READ_WRITE_ALARM_MESSAGE_OBJECT_PUSH_TYPE_VARIABLE_SPEC_const = 0x12;
uint8_t PLC4C_S7_READ_WRITE_ALARM_MESSAGE_OBJECT_PUSH_TYPE_VARIABLE_SPEC() {
  return PLC4C_S7_READ_WRITE_ALARM_MESSAGE_OBJECT_PUSH_TYPE_VARIABLE_SPEC_const;
}

// Parse function.
plc4c_return_code plc4c_s7_read_write_alarm_message_object_push_type_parse(plc4c_spi_read_buffer* readBuffer, plc4c_s7_read_write_alarm_message_object_push_type** _message) {
  uint16_t startPos = plc4c_spi_read_get_pos(readBuffer);
  uint16_t curPos;
  plc4c_return_code _res = OK;

  // Allocate enough memory to contain this data structure.
  (*_message) = malloc(sizeof(plc4c_s7_read_write_alarm_message_object_push_type));
  if(*_message == NULL) {
    return NO_MEMORY;
  }

  // Const Field (variableSpec)
  uint8_t variableSpec = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &variableSpec);
  if(_res != OK) {
    return _res;
  }
  if(variableSpec != PLC4C_S7_READ_WRITE_ALARM_MESSAGE_OBJECT_PUSH_TYPE_VARIABLE_SPEC()) {
    return PARSE_ERROR;
    // throw new ParseException("Expected constant value " + PLC4C_S7_READ_WRITE_ALARM_MESSAGE_OBJECT_PUSH_TYPE_VARIABLE_SPEC + " but got " + variableSpec);
  }

  // Simple Field (lengthSpec)
  uint8_t lengthSpec = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &lengthSpec);
  if(_res != OK) {
    return _res;
  }
  (*_message)->length_spec = lengthSpec;

  // Simple Field (syntaxId)
  plc4c_s7_read_write_syntax_id_type* syntaxId;
  _res = plc4c_s7_read_write_syntax_id_type_parse(readBuffer, (void*) &syntaxId);
  if(_res != OK) {
    return _res;
  }
  (*_message)->syntax_id = *syntaxId;

  // Simple Field (numberOfValues)
  uint8_t numberOfValues = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &numberOfValues);
  if(_res != OK) {
    return _res;
  }
  (*_message)->number_of_values = numberOfValues;

  // Simple Field (eventId)
  uint32_t eventId = 0;
  _res = plc4c_spi_read_unsigned_int(readBuffer, 32, (uint32_t*) &eventId);
  if(_res != OK) {
    return _res;
  }
  (*_message)->event_id = eventId;

  // Simple Field (eventState)
  plc4c_s7_read_write_state* eventState;
  _res = plc4c_s7_read_write_state_parse(readBuffer, (void*) &eventState);
  if(_res != OK) {
    return _res;
  }
  (*_message)->event_state = eventState;

  // Simple Field (localState)
  plc4c_s7_read_write_state* localState;
  _res = plc4c_s7_read_write_state_parse(readBuffer, (void*) &localState);
  if(_res != OK) {
    return _res;
  }
  (*_message)->local_state = localState;

  // Simple Field (ackStateGoing)
  plc4c_s7_read_write_state* ackStateGoing;
  _res = plc4c_s7_read_write_state_parse(readBuffer, (void*) &ackStateGoing);
  if(_res != OK) {
    return _res;
  }
  (*_message)->ack_state_going = ackStateGoing;

  // Simple Field (ackStateComing)
  plc4c_s7_read_write_state* ackStateComing;
  _res = plc4c_s7_read_write_state_parse(readBuffer, (void*) &ackStateComing);
  if(_res != OK) {
    return _res;
  }
  (*_message)->ack_state_coming = ackStateComing;

  // Array field (AssociatedValues)
  plc4c_list* AssociatedValues = NULL;
  plc4c_utils_list_create(&AssociatedValues);
  if(AssociatedValues == NULL) {
    return NO_MEMORY;
  }
  {
    // Count array
    uint16_t itemCount = (uint16_t) numberOfValues;
    for(int curItem = 0; curItem < itemCount; curItem++) {
      bool lastItem = curItem == (itemCount - 1);
      plc4c_s7_read_write_associated_value_type* _value = NULL;
      _res = plc4c_s7_read_write_associated_value_type_parse(readBuffer, (void*) &_value);
      if(_res != OK) {
        return _res;
      }
      plc4c_utils_list_insert_head_value(AssociatedValues, _value);
    }
  }
  (*_message)->associated_values = AssociatedValues;

  return OK;
}

plc4c_return_code plc4c_s7_read_write_alarm_message_object_push_type_serialize(plc4c_spi_write_buffer* writeBuffer, plc4c_s7_read_write_alarm_message_object_push_type* _message) {
  plc4c_return_code _res = OK;

  // Const Field (variableSpec)
  plc4c_spi_write_unsigned_byte(writeBuffer, 8, PLC4C_S7_READ_WRITE_ALARM_MESSAGE_OBJECT_PUSH_TYPE_VARIABLE_SPEC());

  // Simple Field (lengthSpec)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->length_spec);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (syntaxId)
  _res = plc4c_s7_read_write_syntax_id_type_serialize(writeBuffer, &_message->syntax_id);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (numberOfValues)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->number_of_values);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (eventId)
  _res = plc4c_spi_write_unsigned_int(writeBuffer, 32, _message->event_id);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (eventState)
  _res = plc4c_s7_read_write_state_serialize(writeBuffer, _message->event_state);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (localState)
  _res = plc4c_s7_read_write_state_serialize(writeBuffer, _message->local_state);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (ackStateGoing)
  _res = plc4c_s7_read_write_state_serialize(writeBuffer, _message->ack_state_going);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (ackStateComing)
  _res = plc4c_s7_read_write_state_serialize(writeBuffer, _message->ack_state_coming);
  if(_res != OK) {
    return _res;
  }

  // Array field (AssociatedValues)
  {
    uint8_t itemCount = plc4c_utils_list_size(_message->associated_values);
    for(int curItem = 0; curItem < itemCount; curItem++) {
      bool lastItem = curItem == (itemCount - 1);
      plc4c_s7_read_write_associated_value_type* _value = (plc4c_s7_read_write_associated_value_type*) plc4c_utils_list_get_value(_message->associated_values, curItem);
      _res = plc4c_s7_read_write_associated_value_type_serialize(writeBuffer, (void*) _value);
      if(_res != OK) {
        return _res;
      }
    }
  }

  return OK;
}

uint16_t plc4c_s7_read_write_alarm_message_object_push_type_length_in_bytes(plc4c_s7_read_write_alarm_message_object_push_type* _message) {
  return plc4c_s7_read_write_alarm_message_object_push_type_length_in_bits(_message) / 8;
}

uint16_t plc4c_s7_read_write_alarm_message_object_push_type_length_in_bits(plc4c_s7_read_write_alarm_message_object_push_type* _message) {
  uint16_t lengthInBits = 0;

  // Const Field (variableSpec)
  lengthInBits += 8;

  // Simple field (lengthSpec)
  lengthInBits += 8;

  // Simple field (syntaxId)
  lengthInBits += plc4c_s7_read_write_syntax_id_type_length_in_bits(&_message->syntax_id);

  // Simple field (numberOfValues)
  lengthInBits += 8;

  // Simple field (eventId)
  lengthInBits += 32;

  // Simple field (eventState)
  lengthInBits += plc4c_s7_read_write_state_length_in_bits(_message->event_state);

  // Simple field (localState)
  lengthInBits += plc4c_s7_read_write_state_length_in_bits(_message->local_state);

  // Simple field (ackStateGoing)
  lengthInBits += plc4c_s7_read_write_state_length_in_bits(_message->ack_state_going);

  // Simple field (ackStateComing)
  lengthInBits += plc4c_s7_read_write_state_length_in_bits(_message->ack_state_coming);

  // Array field
  if(_message->associated_values != NULL) {
    plc4c_list_element* curElement = _message->associated_values->tail;
    while (curElement != NULL) {
      lengthInBits += plc4c_s7_read_write_associated_value_type_length_in_bits((plc4c_s7_read_write_associated_value_type*) curElement->value);
      curElement = curElement->next;
    }
  }

  return lengthInBits;
}

