/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type COTPParameterChecksum struct {
	Crc    uint8
	Parent *COTPParameter
}

// The corresponding interface
type ICOTPParameterChecksum interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

///////////////////////////////////////////////////////////
// Accessors for discriminator values.
///////////////////////////////////////////////////////////
func (m *COTPParameterChecksum) ParameterType() uint8 {
	return 0xC3
}

func (m *COTPParameterChecksum) InitializeParent(parent *COTPParameter) {
}

func NewCOTPParameterChecksum(crc uint8) *COTPParameter {
	child := &COTPParameterChecksum{
		Crc:    crc,
		Parent: NewCOTPParameter(),
	}
	child.Parent.Child = child
	return child.Parent
}

func CastCOTPParameterChecksum(structType interface{}) *COTPParameterChecksum {
	castFunc := func(typ interface{}) *COTPParameterChecksum {
		if casted, ok := typ.(COTPParameterChecksum); ok {
			return &casted
		}
		if casted, ok := typ.(*COTPParameterChecksum); ok {
			return casted
		}
		if casted, ok := typ.(COTPParameter); ok {
			return CastCOTPParameterChecksum(casted.Child)
		}
		if casted, ok := typ.(*COTPParameter); ok {
			return CastCOTPParameterChecksum(casted.Child)
		}
		return nil
	}
	return castFunc(structType)
}

func (m *COTPParameterChecksum) GetTypeName() string {
	return "COTPParameterChecksum"
}

func (m *COTPParameterChecksum) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *COTPParameterChecksum) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.Parent.ParentLengthInBits())

	// Simple field (crc)
	lengthInBits += 8

	return lengthInBits
}

func (m *COTPParameterChecksum) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func COTPParameterChecksumParse(readBuffer utils.ReadBuffer) (*COTPParameter, error) {
	if pullErr := readBuffer.PullContext("COTPParameterChecksum"); pullErr != nil {
		return nil, pullErr
	}

	// Simple Field (crc)
	crc, _crcErr := readBuffer.ReadUint8("crc", 8)
	if _crcErr != nil {
		return nil, errors.Wrap(_crcErr, "Error parsing 'crc' field")
	}

	if closeErr := readBuffer.CloseContext("COTPParameterChecksum"); closeErr != nil {
		return nil, closeErr
	}

	// Create a partially initialized instance
	_child := &COTPParameterChecksum{
		Crc:    crc,
		Parent: &COTPParameter{},
	}
	_child.Parent.Child = _child
	return _child.Parent, nil
}

func (m *COTPParameterChecksum) Serialize(writeBuffer utils.WriteBuffer) error {
	ser := func() error {
		if pushErr := writeBuffer.PushContext("COTPParameterChecksum"); pushErr != nil {
			return pushErr
		}

		// Simple Field (crc)
		crc := uint8(m.Crc)
		_crcErr := writeBuffer.WriteUint8("crc", 8, (crc))
		if _crcErr != nil {
			return errors.Wrap(_crcErr, "Error serializing 'crc' field")
		}

		if popErr := writeBuffer.PopContext("COTPParameterChecksum"); popErr != nil {
			return popErr
		}
		return nil
	}
	return m.Parent.SerializeParent(writeBuffer, m, ser)
}

func (m *COTPParameterChecksum) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
