/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

type AlarmType uint8

type IAlarmType interface {
	Serialize(writeBuffer utils.WriteBuffer) error
}

const (
	AlarmType_SCAN    AlarmType = 0x01
	AlarmType_ALARM_8 AlarmType = 0x02
	AlarmType_ALARM_S AlarmType = 0x04
)

var AlarmTypeValues []AlarmType

func init() {
	_ = errors.New
	AlarmTypeValues = []AlarmType{
		AlarmType_SCAN,
		AlarmType_ALARM_8,
		AlarmType_ALARM_S,
	}
}

func AlarmTypeByValue(value uint8) AlarmType {
	switch value {
	case 0x01:
		return AlarmType_SCAN
	case 0x02:
		return AlarmType_ALARM_8
	case 0x04:
		return AlarmType_ALARM_S
	}
	return 0
}

func AlarmTypeByName(value string) AlarmType {
	switch value {
	case "SCAN":
		return AlarmType_SCAN
	case "ALARM_8":
		return AlarmType_ALARM_8
	case "ALARM_S":
		return AlarmType_ALARM_S
	}
	return 0
}

func CastAlarmType(structType interface{}) AlarmType {
	castFunc := func(typ interface{}) AlarmType {
		if sAlarmType, ok := typ.(AlarmType); ok {
			return sAlarmType
		}
		return 0
	}
	return castFunc(structType)
}

func (m AlarmType) LengthInBits() uint16 {
	return 8
}

func (m AlarmType) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func AlarmTypeParse(readBuffer utils.ReadBuffer) (AlarmType, error) {
	val, err := readBuffer.ReadUint8("AlarmType", 8)
	if err != nil {
		return 0, nil
	}
	return AlarmTypeByValue(val), nil
}

func (e AlarmType) Serialize(writeBuffer utils.WriteBuffer) error {
	return writeBuffer.WriteUint8("AlarmType", 8, uint8(e), utils.WithAdditionalStringRepresentation(e.name()))
}

func (e AlarmType) name() string {
	switch e {
	case AlarmType_SCAN:
		return "SCAN"
	case AlarmType_ALARM_8:
		return "ALARM_8"
	case AlarmType_ALARM_S:
		return "ALARM_S"
	}
	return ""
}

func (e AlarmType) String() string {
	return e.name()
}
