/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"fmt"
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const ModbusConstants_MODBUSTCPDEFAULTPORT uint16 = 502

// The data-structure of this message
type ModbusConstants struct {
}

// The corresponding interface
type IModbusConstants interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

func NewModbusConstants() *ModbusConstants {
	return &ModbusConstants{}
}

func CastModbusConstants(structType interface{}) *ModbusConstants {
	castFunc := func(typ interface{}) *ModbusConstants {
		if casted, ok := typ.(ModbusConstants); ok {
			return &casted
		}
		if casted, ok := typ.(*ModbusConstants); ok {
			return casted
		}
		return nil
	}
	return castFunc(structType)
}

func (m *ModbusConstants) GetTypeName() string {
	return "ModbusConstants"
}

func (m *ModbusConstants) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *ModbusConstants) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(0)

	// Const Field (modbusTcpDefaultPort)
	lengthInBits += 16

	return lengthInBits
}

func (m *ModbusConstants) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func ModbusConstantsParse(readBuffer utils.ReadBuffer) (*ModbusConstants, error) {
	if pullErr := readBuffer.PullContext("ModbusConstants"); pullErr != nil {
		return nil, pullErr
	}

	// Const Field (modbusTcpDefaultPort)
	modbusTcpDefaultPort, _modbusTcpDefaultPortErr := readBuffer.ReadUint16("modbusTcpDefaultPort", 16)
	if _modbusTcpDefaultPortErr != nil {
		return nil, errors.Wrap(_modbusTcpDefaultPortErr, "Error parsing 'modbusTcpDefaultPort' field")
	}
	if modbusTcpDefaultPort != ModbusConstants_MODBUSTCPDEFAULTPORT {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", ModbusConstants_MODBUSTCPDEFAULTPORT) + " but got " + fmt.Sprintf("%d", modbusTcpDefaultPort))
	}

	if closeErr := readBuffer.CloseContext("ModbusConstants"); closeErr != nil {
		return nil, closeErr
	}

	// Create the instance
	return NewModbusConstants(), nil
}

func (m *ModbusConstants) Serialize(writeBuffer utils.WriteBuffer) error {
	if pushErr := writeBuffer.PushContext("ModbusConstants"); pushErr != nil {
		return pushErr
	}

	// Const Field (modbusTcpDefaultPort)
	_modbusTcpDefaultPortErr := writeBuffer.WriteUint16("modbusTcpDefaultPort", 16, 502)
	if _modbusTcpDefaultPortErr != nil {
		return errors.Wrap(_modbusTcpDefaultPortErr, "Error serializing 'modbusTcpDefaultPort' field")
	}

	if popErr := writeBuffer.PopContext("ModbusConstants"); popErr != nil {
		return popErr
	}
	return nil
}

func (m *ModbusConstants) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
